/*******************************************************************************
 * Copyright (c) 2005, 2006 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Karla Callaghan, Intel - Initial API and Implementation
 *
 * $Id: ProcCtlUtils.h,v 1.12 2006/07/24 19:53:07 koleary Exp $ 
 *******************************************************************************/ 

#ifndef __PROC_CTL_UTILS_H__
#define __PROC_CTL_UTILS_H__

#include "tptp/TPTPCommon.h"
#include "tptp/TPTPProcCtlDefs.h"
#include "tptp/TPTPConfigBinding.h"

#ifdef __cplusplus
extern "C"
{
#endif

typedef struct
{
	char* eventInterfaceID; //ID of the interface with the events of interest
	int listenerID;		//an arbitrary value provided by the listener (the context value in the event msg)
	int destID;			//where to send an event (the sourceID of the listener)
}  tptp_listener_t;


typedef struct
{

	/* info from the startProcess cmd */
	int ownerID;		/* source ID - who sent the cmd (process owner) */
	int ownerContext;	/* context set by requestor */
	char* appName;		/* executable name */
	char* cmdLineArgs;	/* args to use in the launch */
	char* workingDir;	/* dir from which to launch */
	char* envVars;		/* environment vars to use in launch */
	int keepProcess;	/* if =1, do not kill this process when owner goes away */
	int noNotices;		/* if =1, do not send owner a msg when this process dies */
	/* following are used only if have app requiring console I/O */
	char* consoleUniqueID;	/* used to form console pipename */
	int consoleConnID;	/* connection ID for console data path */
	/* following are used once process is launched */
	PID   pid;
#ifdef _WIN32
	TPTP_HANDLE hProcess;
#endif
	tptp_list_t* monitors; /* list of IDs to send events about this process to */
	char *uuid;            /* compatibiity requires us to associate a uuid with a pid */
} tptp_process_t;

/*
 * The structure that contains information regarding console connection
 */
typedef struct {
	//RA_HANDLE remote;
	RA_HANDLE in;
	RA_HANDLE out;
	RA_HANDLE err;
} RemoteConsole_t;

tptp_process_t* initProcessT(const int sourceID, const int context, const char* appName,
							 const char* cmdLineArgs, const char* workingDir,
							 const char* envVars, const int consoleConnID,
							 const unsigned int optionsFlag);
tptp_process_t* cloneProcessT(const tptp_process_t* proc);
int copyProcessNode(const tptp_node_t* node, tptp_node_t* nodeCopy);
void destroyProcessT(tptp_process_t* proc);
int destroyProcessNode(tptp_node_t* node);

tptp_listener_t* initListenerT(const int destID, const int listenerID, const char* eventsIID);
tptp_listener_t* cloneListenerT(const tptp_listener_t* listener);
int copyListenerNode(const tptp_node_t* node, tptp_node_t* nodeCopy);
void destroyListenerT(tptp_listener_t* listener);
int destroyListenerNode(tptp_node_t* node);

/* Calls needed for process environment expansion/setting */
void* modifyApplicationEnvironment(tptp_list_t *variables, void *parentEnv);
char* modifyApplicationParameters(tptp_list_t *parameters, tptp_string *args);
void *getEnvironmentStrings();
void freeEnvironmentStrings(void *env);


int checkExecutable(const char* appName, unsigned long* errCode);
int checkDirectoryReadWriteAccess(const char* dir, unsigned long* errCode);
int checkDirectoryReadAccess(const char* dir, unsigned long* errCode);
int createProc(tptp_process_t* proc, RemoteConsole_t* console, unsigned long* errCode);
int terminateProc(const tptp_process_t* proc);
BOOL isProcessActive( PID pid );

#ifdef __cplusplus
} /* Ends extern C */
#endif

#endif /* __PROC_CTL_UTILS_H__*/

