/*******************************************************************************
 * Copyright (c) 2003-2005 IBM, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu Naikawadi Intel - Command Utility Class (Provides Command Building API)
 *
 * $Id: TPTPCommand.h,v 1.6 2005/10/04 02:38:22 kcallaghan Exp $ 
 ******************************************************************************/ 


#ifndef __TPTPCommand_H__
#define __TPTPCommand_H__

#include "tptp/TPTPExport.h"
#include "tptp/TPTPUtils.h"


#include <string>


class TPTP_CLASS_EXPORT TPTPCommand
{
	private:
		int _sourceID;
		int _destID;
		int _contextID;
		char* _iid;
		char* _commandName;
		tptp_list_t _paramList;
		std::string _commandString;

	public:

		TPTPCommand();

		TPTPCommand(int srcID, int destID, int contextID, char* iid, char* commandName);

		~TPTPCommand();

		void setSourceID(int srcID);

		void setDestID(int destID);

		void setContextID(int contextID);

		void setIID(char* iid);

		void setCommandName(char* commandName);

		void setParamList(tptp_list_t* paramList);

		int getSourceID();

		int getDestID();

		int getContextID();

		char* getIID();

		char* getCommandName();

		tptp_list_t* getParamList();

		char* buildCommandString();

		char* buildCommandString(int srcID, int destID, int contextID, char* iid, char* commandName);

		char* buildReplyCommandString(TPTPCommand* inputCommand, char* commandName);

		char* buildReplyCommandString(TPTPCommand* inputCommand, char* commandName, char* iid);

		void addIntegerParam(char* name, int value);

		void addStringParam(char* name, char* value);

		void addPIDParam(char* name, PID value);

		bool isComplete();
};



#endif  /* __TPTPCommand_H__ */
