/*******************************************************************************
 * Copyright (c) 2003, 2010 IBM, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Andy Kaylor, Intel - Initial re-implementation of Agent Controller
 *    IBM - Portions of old RAC code (brought over by Andy Kaylor)
 *    Karla Callaghan, Intel - added defs for TPTP
 *
 * $Id: TPTPCommon.h,v 1.19 2010/04/01 18:47:08 jwest Exp $ 
 ******************************************************************************/ 


#ifndef __TPTPCOMMON_H__
#define __TPTPCOMMON_H__


#define  TPTP_DEFAULT_BUFFER_LENGTH  8096
#define  TPTP_DEFAULT_BUFFER_MAX_LENGTH  TPTP_DEFAULT_BUFFER_LENGTH+1

#define  TPTP_DEFAULT_UUID_MAX_LENGTH  256

/**
  * Platform specific includes.
  */
#ifdef _WIN32										/* Win32 */
	#include <windows.h>
#else												/* else */
	#include <pthread.h>
//	#include <arpa/inet.h> //tptpSupportTypes.h has def for in_addr which collides
	#include <sys/types.h>
	#include <unistd.h>
	#if defined(__OS400__)  || defined(MVS)
 		#include <stdlib.h>
 		#ifdef MVS
			/*  228721 - for 390, strings.h is needed to define bzero() */
			#include <strings.h>
		#endif
		/* 190770 - for 390, including string.h causes run-time
		library functions to be inlined to improve performance */
		#include <string.h>
	#else
		#include <strings.h>
	#endif
#endif

#ifdef _HPUX
	#include <string.h>
	#include <malloc.h>
	#include <unistd.h>
#endif

#include "TPTPTypes.h"

/* Mutex */
#ifdef _WIN32
	#define ra_critsec_t CRITICAL_SECTION
#else
	#define ra_critsec_t pthread_mutex_t
#endif

/**
  * Macros/typedefs to ease the readability of multiplatform code.
  */
#ifdef _WIN32										/* Win32 */
 #define BZERO(mem, len) ZeroMemory(mem,len)
 #define SLEEP(millisec) Sleep(millisec)
 #define STRDUP(dest, src)  dest=strdup(src)
 #define PATH_SEPARATOR ';'
 #define FILE_SEPARATOR '\\'
 typedef DWORD TID;
// typedef DWORD PID;
 typedef HANDLE RA_HANDLE;
 typedef HANDLE TPTP_HANDLE;
 #define RA_HANDLE_NULL	NULL
 #define TPTP_HANDLE_NULL NULL
 #define CLOSE_RA_HANDLE(handle)		CloseHandle(handle)
 #define CLOSE_TPTP_HANDLE(handle)		CloseHandle(handle)
 #define CLOSE_THREAD_HANDLE(handle)	CloseHandle(handle)
#else
 #define INVALID_HANDLE_VALUE -1
 #define _MAX_PATH 256 /* This is already defined on Windows */
 #if defined (__OS400__)
  #define BZERO(mem, len) memset(mem, '\0', len)
  #define STRDUP(dest, src)  dest=(char*)malloc(strlen(src)+1); BZERO(dest, strlen(src)+1); strcpy(dest, src) /* 236501 */
 #elif defined (_HPUX)
  #define BZERO(mem, len) memset(mem, '\0', len)
  #define STRDUP(dest, src)  dest=strdup(src)
 #else
  #define BZERO(mem, len) bzero(mem,len)
  #define STRDUP(dest, src)  dest=strdup(src)
 #endif

#ifdef __cplusplus
extern "C" {
#endif
 void  tptpSleep(int milliseconds) ;
#ifdef __cplusplus
}
#endif

 #define SLEEP(millisec)  tptpSleep(millisec)

 #define PATH_SEPARATOR ':'
 #define FILE_SEPARATOR '/'
 typedef int SOCKET;
 /* BUG 306857 */
 #ifndef INVALID_SOCKET
	#define INVALID_SOCKET (-1)
 #endif

 typedef int HANDLE;
 typedef int RA_HANDLE;
 typedef int TPTP_HANDLE;
 #define RA_HANDLE_NULL 0
 #define TPTP_HANDLE_NULL 0
 #define CLOSE_RA_HANDLE(handle)		close(handle)
 #define CLOSE_TPTP_HANDLE(handle)		close(handle)
 #define CLOSE_THREAD_HANDLE(handle)
 #define WINAPI " "
 typedef pthread_t TID;
/* typedef unsigned long PID; 179338 */
// typedef pid_t PID;    /* 179338 */

#ifdef MVS
#pragma pack(full)
#endif
  #ifndef BOOL
  /* TO protect BOOL redef if system.h included first.
   */
  #ifdef FALSE
   #undef FALSE
  #endif
  #ifdef TRUE
   #undef TRUE
  #endif
  /* Unfortunately, the Solaris C++ compiler doesn't like
     the version that all the other compilers like
  */
  #if (defined(_SOLARIS) || defined(_SOLARISX86)) && defined __cplusplus
   typedef enum BOOL {FALSE, TRUE};
  #else
   enum _BOOL {FALSE, TRUE};
   typedef enum _BOOL BOOL;
  #endif
  
 #endif /*ndef BOOL*/
 
#ifdef MVS
#pragma pack(reset)
#endif
#endif

  
/* Predefined destination ID for commands */
/* TODO: Use these IDs to make context IDs more likely to be unique */
#define AGENT_MANAGER       1
#define CONNECTION_MANAGER	2
#define LOGGING_SERVICE		3

/* Common Interface ID strings */
#define PROCESS_CONTROLLER_IID "org.eclipse.tptp.processController"
#define AGENT_MANAGER_IID "org.eclipse.tptp.agentManager"
#define EVENT_PROVIDER_IID "org.eclipse.tptp.eventProvider"
#define TPTP_ERROR_IID "org.eclipse.tptp.Error"
#define AGENTMGR_AGENT_EVENTS_IID "org.eclipse.tptp.agentManager.agentEvents"

/* Provide unified string access methods across all platforms. */


/* Macros to make shared library loading portable */
#ifdef _WIN32
 #define DLL_REFERENCE HINSTANCE
 #define LOAD_LIBRARY(name) LoadLibrary(name)
 #define RESOLVE_ENTRY_POINT(mod, entry) GetProcAddress(mod, entry)
 /* In support of BUG 307787 */
 #define SHARED_LIB_PREFIX ""
 #define SHARED_LIB_SUFFIX ".dll"
#elif MVS
 #include <dll.h>
 #include <dlfcn.h>
 #define DLL_REFERENCE dllhandle *
 #define LOAD_LIBRARY(name) dlopen(name, RTLD_LAZY)
 #define RESOLVE_ENTRY_POINT(mod, entry) dlsym(mod, entry)
// old: #define LOAD_LIBRARY(name) dllload(name)
// old: #define RESOLVE_ENTRY_POINT(mod, entry) dllqueryfn(mod, entry)
 /* In support of BUG 307787 */
 #define SHARED_LIB_PREFIX "lib"
 #define SHARED_LIB_SUFFIX ".so"
#elif _HPUX
 #include <dlfcn.h>
 #define DLL_REFERENCE void *
 #define LOAD_LIBRARY(name) dlopen(name, RTLD_LAZY)
 #define RESOLVE_ENTRY_POINT(mod, entry) dlsym(mod, entry)
 /* In support of BUG 307787 */
 #define SHARED_LIB_PREFIX "lib"
 #define SHARED_LIB_SUFFIX ".so"
#elif __OS400__

/* Shouldn't there be something here? */

#else
 #include <dlfcn.h>
 #define MODULE_REFERENCE void *
 #define DLL_REFERENCE void *
 #define LOAD_LIBRARY(name) dlopen(name, RTLD_LAZY)
 #define RESOLVE_ENTRY_POINT(mod, entry) dlsym(mod, entry)
 /* In support of BUG 307787 */
#ifdef __APPLE__
 #define SHARED_LIB_PREFIX "lib"
 #define SHARED_LIB_SUFFIX ".dylib"
#else
 #define SHARED_LIB_PREFIX "lib"
 #define SHARED_LIB_SUFFIX ".so"
#endif /* __APPLE__ */
#endif

#endif /* __TPTPCOMMON_H__	*/
