/*******************************************************************************
 * Copyright (c) 2005, 2008 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Randy D. Smith, Intel - Refactored several instantiations into one
 *
 * $Id: TPTPConfig.h,v 1.16 2008/12/17 19:36:31 jwest Exp $
 *******************************************************************************/ 

#ifndef TPTPCONFIG_H_
#define TPTPCONFIG_H_

#include "tptp/TPTPUtils.h"
#include "tptp/TPTPCommon.h"

#include <stdio.h>
#ifndef _WIN32
#include <dirent.h>
#endif
#include <sys/stat.h>

typedef struct
{
    char*   name;
    char*   type;
    char*   value;
} tptp_option_t;

typedef struct
{
    char*        agentName;
    tptp_list_t  interfaces;
    int          singleInstance;
    int          bound;
    int          maxControllers;
    int          maxObservers;
    char*        launchInfo;
    char*        clientData;
    char*        fullMetadata;
    tptp_list_t  options;             /* tptp_option_t */
    char*        dataChannelSize;  	/* these next 5 are added for compatibility*/
    char*        logFile;
    char*        client;
} agent_metadata_t;

typedef struct
{
    char*        transportLayerLib;
    char*        transportLayerConfig;
	char*        transportType;
    char*        commandExtractorLib;
} message_pipeline_config_t;

enum _position { PREPEND, APPEND, REPLACE };
typedef enum _position position_t;
/*
 * Variable
 */
typedef struct {
    tptp_string* name;
    tptp_string* value;
    position_t position;
}variable_t;

/*
 * Parameter
 */
typedef struct {
    tptp_string* value;
    position_t position;
}parameter_t;

typedef struct AppLabel
{
    char        *executable;
    char        *path;
    char        *location;
    char        *extends;
    tptp_list_t *variables;  /* list of variable_t (environment vars) */
    tptp_list_t *parameters; /* list of parameter_t (cmd line args)   */
}App_Label_t;

typedef struct ACConfig
{
    char                          *version;
    char                          *envConfig; /* env info to use in launching new processes */
    char                          *applicationAliases; /* string of Application alias tags */ 
	char                          *peerConnectionTransport; /* transport type to be used for peer monitoring */
    char                          *agentConfigLocation;
    char                          *pluginConfigLocation;
    char                          *loggingDirectory;
    tptp_int32                    loggingLevel;
    tptp_loggingFormat            loggingFormat;
    tptp_list_t                   options;         /* tptp_option_t      */
    tptp_list_t                   agentList;       /* agent_metadata_t   */
    tptp_list_t                   msgPipelineList; /* message_pipeline_t */
    char                          *procCntlrAgent;
	char						  *jvmLibPath;
    struct ConnectionManager_tag* connectionManager;
} AC_Config_t;

typedef struct
{
    char* name;
    char* value;
} agent_custom_data_t;

typedef struct
{
    char*       agentName;
    char*       loggingLevel;
    char*       acNamedPipeName;
    char*       acSharedMemName;
    tptp_list_t	agentCustomData;
} agent_config_t;

typedef tptp_int32 (*logConfigEventCallback_ptr_t)(void* cmo, int severity, tptp_string* errStr);

#ifdef __cplusplus
extern "C"
{
#endif

void initializeTPTPConfig();
void terminateTPTPConfig();
int getXMLFileSize(char *XMLfilename, long *fileSize);
void logServiceMessage(char *file, int line, const char *msg);
void printList(tptp_list_t *inputList);

int loadTPTPConfig(char *acConfigFile, AC_Config_t *ac_config, BOOL calledByAC);
AC_Config_t* getTPTPConfig();
int parseApplicationAliases(char *applicationString, tptp_list_t **pUserAppList, int *launchAliasesOnly);
int parseApplication(char *applicationString, App_Label_t **pLabel);

App_Label_t* initAppLabelT(const char* exe, const char* path, const char* loc, const char *extends);
App_Label_t* cloneAppLabelT(const App_Label_t* appLabel);
int copyAppLabelNode(const tptp_node_t* node, tptp_node_t* nodeCopy);
void destroyAppLabelT(App_Label_t* appLabel);
int destroyAppLabelNode(tptp_node_t* node);

parameter_t* initParameterT(const char* value, position_t position);
parameter_t* cloneParameterT(const parameter_t* param);
int copyParameterNode(const tptp_node_t* node, tptp_node_t* nodeCopy);
void destroyParameterT(parameter_t* param);
int destroyParameterNode(tptp_node_t* node);

variable_t* initVariableT(const char* name, const char* value, position_t position);
variable_t* cloneVariableT(const variable_t* variable);
int copyVariableNode(const tptp_node_t* node, tptp_node_t* nodeCopy);
void destroyVariableT(variable_t* var);
int destroyVariableNode(tptp_node_t* node);

tptp_option_t* initOptionT(char* config, const char* name, const char* value, const char *type);
tptp_option_t* cloneOptionT(const tptp_option_t* option);
int copyOptionNode(const tptp_node_t* node, tptp_node_t* nodeCopy);
void destroyOptionT(tptp_option_t* var);
int destroyOptionNode(tptp_node_t* node);

int getEnvironmentVariable(char* name, char* buffer, int size);
void setEnvironment(char *name, char *value, char *position);
void appendEnvironment(char *name, char *value);
int parseAgentMetaData(agent_metadata_t* metadata, char* agentConfigFileName);
int loadAgentConfig(AC_Config_t *acconfig);
char* getCacheEnv(char *config, char *name); /* Bug 161220 */

/*int loadAgentConfig(BaseAgentImpl* pAgentIn, char* agentConfigFileName, agent_config_t* agentConfig);*/

#ifdef __cplusplus
} // extern "C"
#endif

#ifdef _WIN32
    #define SERVICE_CONFIG_FILE_NAME		"\\serviceconfig.xml"
    #define SERVICE_LOG_FILE_NAME			"\\servicelog.log"
    #define RELATIVE_CONFIGURATION_DIR	    "\\config"
	#define CONFIG_FILE_PATH				"\\config\\serviceconfig.xml"
	#define PARENT_CONFIG_FILE_PATH			"..\\config\\serviceconfig.xml"
	#define PARENT_CONFIG_DIR_PATH			"..\\config"
	#define SLASH_PARENT_CONFIG_FILE_PATH	"\\..\\config\\serviceconfig.xml"
	#define PLUGIN_CONFIG_FILE_NAME			"pluginconfig.xml"
    #define PLUGIN_CONFIG_FILE_PATH			"\\config\\pluginconfig.xml"
	
#else
    #define SERVICE_CONFIG_FILE_NAME		"/serviceconfig.xml"
    #define SERVICE_LOG_FILE_NAME			"/servicelog.log"
    #define RELATIVE_CONFIGURATION_DIR	    "/config"
	#define CONFIG_FILE_PATH				"/config/serviceconfig.xml"
	#define PARENT_CONFIG_FILE_PATH			"../config/serviceconfig.xml"
	#define PARENT_CONFIG_DIR_PATH			"../config"
	#define SLASH_PARENT_CONFIG_FILE_PATH	"/../config/serviceconfig.xml"
	#define PLUGIN_CONFIG_FILE_NAME			"pluginconfig.xml"
    #define PLUGIN_CONFIG_FILE_PATH			"/config/pluginconfig.xml"
	
#endif

//#define DEBUG true
#define _logFile "servicelog.log"

#define AC_MAX_PATH _MAX_PATH

#define AGENT_FILE "agent.xml"

#define ENV_SIZE 8192
#define ELEMENT_NAME_AGENT_CONTROLLER_CONFIGURATION "AgentControllerConfiguration"
#define ELEMENT_NAME_AGENT_CONTROLLER_ENVIRONMENT "AgentControllerEnvironment"
#define ELEMENT_NAME_PROCESS_CONTROLLER_AGENT_NAME "ProcessController"
#define ELEMENT_NAME_FILE_TRANSFER_AGENT_NAME "FileTransfer"
#define	ELEMENT_NAME_PIPE_TL "NamePipe"
#define ELEMENT_NAME_AGENT "Agent"
#define ELEMENT_NAME_CONNECTION "Connection"
#define ELEMENT_NAME_ALLOW "Allow"
#define ELEMENT_NAME_APPLICATION "Application"
#define ELEMENT_NAME_DENY "Deny"
#define ELEMENT_NAME_GROUP "Group"
#define ELEMENT_NAME_GROUP_DEFINITION "GroupDefinition"
#define ELEMENT_NAME_HOSTS "Hosts"
#define ELEMENT_NAME_MEMBER "Member"
#define ELEMENT_NAME_OPTION "Option"
#define ELEMENT_NAME_PARAMETER "Parameter"
#define ELEMENT_NAME_AGENT_CONFIGURATION "AgentConfiguration"
#define ELEMENT_NAME_AGENT_DIRECTORY "Agents"
#define ELEMENT_NAME_SECURITY "Security"
#define ELEMENT_NAME_SERVICE "Service"
#define ELEMENT_NAME_USER_DEFINITION "UserDefinition"
#define ELEMENT_NAME_VARIABLE "Variable"
#define ELEMENT_TRANS_LYR_VARIABLE "TransportLayer"
#define ELEMENT_CONFIGURATION_VARIABLE "Configuration"
#define ATTRB_TRANSTYPE_VARIABLE    "type"
#define ATTRB_TL_LIBNAME            "loadlib"
#define ELEMENT_CMD_EXTR_VARIABLE   "CommandExtractor"
#define ELEMENT_NAME_APPL_ALIASES   "ApplicationAliases"
#define ELEMENT_NAME_PM_TRANSPORT   "PeerConnectionTransport"
#define ELEMENT_NAME_LOGGING        "Logging"

#define ELEMENT_NAME_ROOT		"AgentConfiguration"
#define ELEMENT_NAME_LOG_LEVEL "LoggingLevel"
#define ELEMENT_NAME_AC_NAMED_PIPE "ACNamedPipeName"
#define ELEMENT_NAME_AC_SHARED_MEM "ACSharedMemName"
#define ELEMENT_NAME_AGENT_CUSTOM_DATA "AgentCustomData"

#define ATTRB_NAME_AC_ENV_CONFIG	"configuration"
#define ATTRB_NAME_LOGGING_FORMAT	"format"
#define ATTRB_NAME_LOGGING_LEVEL	"level"
#define ATTRB_NAME_LOGGING_DIR		"directory"
#define ATTRB_NAME_AC_VERSION		"version"
//The following APP attributes are for the label stuff
//This will be added to a list and the ProcessController will request the AC
//for this list -- If any of the executable, path or location values are NULL
//it will not be added to the list
#define ATTRB_NAME_APP_EXEC			"executable"
#define ATTRB_NAME_APP_PATH			"path"
#define ATTRB_NAME_APP_LOCATION		"location"

//Agent Related Config Info
#define ELEMENT_NAME_AGENT_NAME		"Agent"
#define ELEMENT_NAME_AGENT_INTRF	"Interface"    
#define ELEMENT_NAME_AGENT_INST		"SingleInstance"
#define ELEMENT_NAME_AGENT_BOUND	"Bound"    
#define ELEMENT_NAME_AGENT_CNTLR	"MaxControllers"    
#define ELEMENT_NAME_AGENT_OBSR		"MaxObservers"    
//Modify this value for the agent launch info - I am calling it as LaunchConfiguration
#define ELEMENT_NAME_AGENT_LNCH		"LaunchConfiguration"    
#define ELEMENT_NAME_AGENT_CLDATA	"ClientData"    
#define ELEMENT_NAME_AGENT_CFGFILE	"ConfigFile"
//Agent Config - AgentName
#define ATTRB_AGENT_NAME			"Name"
// JVM configuration
#define ELEMENT_NAME_JVM    "Jvm"

#define ATTRB_USER_TYPE		"type"
#define ATTRB_USER_LIST		"list"
#define ATTRB_HOST_TYPE		"type"
#define ATTRB_HOST_LIST		"list"


#define HOST_TYPE_LOCAL  "LOCAL"
#define HOST_TYPE_ALL  "ALL"
#define HOST_TYPE_CUSTOM  "CUSTOM"

#define USER_TYPE_ALL  "ANY"
#define USER_TYPE_CUSTOM  "CUSTOM"

#define EMPTY_DATA_CHANNEL	"NONE"
#define PLUGIN_HOME_VAR_NAME "%PLUGINS_HOME%"
#define RASERVER_HOME_CONFIG_NAME "RASERVER_HOME"
#define CHKPASS_CMD		"ChkPass" 

#define SPACE	" "
#define EQUALSIGN "="
#define DOUBLEQUOTE "\""

#define APPLICATION_ALIASES_OPENING_TAG "<ApplicationAliases>"
#define APPLICATION_ALIASES_CLOSING_TAG "</ApplicationAliases>"
#define PLUGIN_LEGACY_PREFIX "org.eclipse.tptp.legacy."
#endif /*TPTPCONFIG_H_*/
