/*******************************************************************************
 * Copyright (c) 2005, 2010 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Hoang M Nguyen, Intel - Initial API and Implementation
 *
 * $Id: TPTPErrorCode.h,v 1.18 2010/04/01 18:47:07 jwest Exp $
 *
 *******************************************************************************/ 



#ifndef TPTPErrorCode_H
#define TPTPErrorCode_H

#define TPTP_MAX_ERROR_STRLEN	256 /* max length of an error string */

/**
 *   generic error/success code range: -1000 through 1000 
 */
#define   TPTP_OK              0
#define   TPTP_SUCCESS         0

/**
 * System Errors: Range 1000 - 1999
 *
 * For mapping platform-form specific errors. This list
 * should represent a union of the errors found on all the
 * platforms supported by this code.
 */
#define TPTP_SYS_UNSPECIFIED_ERR				1000	/* used for errs not yet mapped here */
#define TPTP_SYS_PROC_NOT_FOUND					1001	/* process not found by the system */
#define TPTP_SYS_ACCESS_DENIED					1002	/* does not have permission */
#define TPTP_SYS_INVALID_SIGNAL					1003
#define TPTP_SYS_INVALID_HANDLE					1004
#define TPTP_SYS_FILE_NOT_FOUND					1005	/* file not found */
#define TPTP_SYS_NO_MEM							1006
#define TPTP_SYS_SEMAPHORE_FAILED				1007

/**
 * General TPTP errors: Range 2000 - 2999
 */
#define TPTP_CMD_MISSING_ARG					2001 /*missing required arg for a cmd*/
#define TPTP_CMD_UNKNOWN						2002 /*not recognized for this interface*/
#define TPTP_UNEXPECTED_NULL_ARG				2003
#define TPTP_CMD_BAD_ARG						2004 /*arg exists, but not useable (e.g.,can't parse xml)*/
#define TPTP_INTERFACE_UNKNOWN                  2005 /*the interface is not handled by this component*/

/**
 * Agent Manager errors: Range 3000 - 3999
 */
#define TPTP_AM_ERROR_LAUNCHING_AGENT          3001
#define TPTP_AM_AGENT_NOT_FOUND                3002
#define TPTP_AM_AGENT_IS_LOCKED                3003
#define TPTP_AM_CONTROLLER_ACCESS_DENIED       3004
#define TPTP_AM_OBSERVER_ACCESS_DENIED         3005
#define TPTP_AM_AGENT_NOT_REFERENCED           3006  /* Someone who wasn't an observer requested control */
#define TPTP_AM_AGENT_NOT_CONTROLLED           3007  /* Someone who wasn't a controller tried to release control */
#define TPTP_AM_NO_PROCESS_CONTROLLER          3008
#define TPTP_AM_AGENT_LAUNCH_FAILED            3009
#define TPTP_AM_DATA_CONNECTION_NOT_FOUND      3010
#define TPTP_AM_DATA_CONNECTION_ALREADY_BOUND  3011
#define TPTP_AM_DATA_CONNECTIONS_INCOMPATIBLE  3012
#define TPTP_AM_NO_DATA_RECEIVER               3013
#define TPTP_AM_NO_METADATA                    3014
#define TPTP_AM_TL_MISSING_FUNC                3015
#define TPTP_AM_TL_MISSING_DESCRIPTOR          3016
#define TPTP_AM_NO_PMI                         3017
#define TPTP_AM_CANT_CONNECT_TO_PEER           3018
#define TPTP_AM_ERR_SENDING_PEER_REQUEST       3019
#define TPTP_AM_NO_PM_TRANSPORT                3020
#define TPTP_AM_ACPATH_NOT_FOUND               3021 /* BUG 307787 */

/**
 *   TPTP transport specific error code range:  5000 - 5999
 * 
 *      Named Pipe:      5000-5200
 *      Shared Memory:   5201-5400
 *      Socket:          5401-5600
 *      Peer monitoring  5601-5700
 *
 */
#define   TPTP_UNABLE_TO_CREATE_NAMED_PIPE       -5000
#define   TPTP_UNABLE_TO_OPEN_NAMED_PIPE         -5001
#define   TPTP_UNABLE_TO_READ_FROM_NAMED_PIPE    -5002
#define   TPTP_PIPE_HAS_ENDED                    -5003
#define   TPTP_UNABLE_TO_WRITE_TO_NAMED_PIPE     -5004
#define   TPTP_NO_NAMED_PIPE_READER              -5005


#define   TPTP_UNABLE_TO_CREATE_SHARED_MEM_KEY    5201
#define   TPTP_UNABLE_TO_CREATE_SHARED_MEM_BLK    5202
#define   TPTP_UNABLE_TO_OPEN_SHARED_MEM_BLK      5203
#define   TPTP_UNABLE_TO_ATTACH_SHARED_MEM_BLK    5204

#define   TPTP_REQUEST_IS_LOCAL                   5601   /* An AC requested a connection to itself */
/**
 *	Process Controller specific error codes range: 6000-6999
 */
#define TPTP_PC_UNSPECIFIED_ERR						6000
#define TPTP_PC_UNABLE_TO_MONITOR_PROCESS			6001
#define TPTP_PC_UNABLE_TO_TERM_CHILD_PROCESSES		6002
#define TPTP_PC_UNABLE_TO_START_PROCESS				6003
#define TPTP_PC_UNABLE_TO_STOP_PROCESS				6004
#define TPTP_PC_UNABLE_TO_ADD_EVENT_LSTNR			6005
#define TPTP_PC_EXECUTABLE_NOT_FOUND				6006 /* file not found or is not executable */
#define TPTP_PC_FILE_IS_A_DIR						6007
#define TPTP_PC_FILE_NOT_EXECUTABLE					6008 /* file exists but not executable */
#define TPTP_PC_DIR_NOT_FOUND						6009
#define TPTP_PC_FILE_NOT_A_DIR						6010
#define TPTP_PC_DIR_NO_WRITE_ACCESS					6011
#define TPTP_PC_PROC_NOT_FOUND						6012 /* process not in PC's list */
#define TPTP_PC_PROC_NO_STOP						6013 /* PC does not have rights to stop proc */
#define TPTP_PC_CONSOLE_CONNECT_FAILED				6014
#define TPTP_PC_CONSOLE_PIPE_CREATE_FAILED			6015
#define TPTP_PC_CONSOLE_PIPE_OPEN_FAILED			6016
#define TPTP_PC_START_PROC_LIST_EMPTY				6017
#define TPTP_PC_OPEN_PROC_FAILED					6018
#define TPTP_PC_APP_ALIAS_REQUIRED					6019
#define TPTP_PC_DIR_NO_READ_ACCESS					6020


/**
 * Agent specific error codes range: 8000-8999
 */
#define TPTP_AGENT_CANT_OPEN_AC_COMM		8001 /* can't open the communication channel with the AC */
#define TPTP_AGENT_CANT_WRITE_AC_COMM		8002 /* failure while trying to write to the AC comm channel */

#endif


