/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Andy Kaylor, Intel - Complete replacement of logging macros
 *
 * $Id: TPTPLog.h,v 1.6 2005/09/12 17:57:37 akaylor Exp $ 
 ******************************************************************************/ 


#ifndef __TPTPLOG_H__
#define __TPTPLOG_H__

#include <stdio.h>

enum _tptpLogLevel {
	TPTP_DEBUG = 5,
	TPTP_INFORMATION = 10,
	TPTP_HARMLESS = 20,
	TPTP_WARNING = 30,
	TPTP_MINOR = 40,
	TPTP_CRITICAL = 50,
	TPTP_SEVERE = 55,
	TPTP_FATAL = 60
};

typedef enum _tptpLogLevel TPTPLogLevel;

#define TPTP_MAX_MSG_SIZE  8192

/*****************************************************************************************************
 *																									 *
 * To use these log macros, a component must define the following:									 *
 *																									 *
 *    RESOLVE_LOG_EVENT_FUNC(p)      resolves to a logEvent function pointer						 *
 *    RESOLVE_INITIAL_PARAM(p)       if a parameter is needed before the subcomponent, this macro 	 *
 *                                     should give that parameter, including the separating comma	 *
 *                                     if no such parameter is needed this macro should resolve to	 *
 *                                   white space													 *
 *    TPTP_LOG_SUBCOMPONENT_NAME(p)  the name of the subcomponent to appear in the log file			 *
 *    TPTP_LOG_INSTANCE_ID(p)        an instance ID for the log file								 *
 *																									 *
 *****************************************************************************************************/

#ifndef RESOLVE_LOG_EVENT_FUNC
#error  RESOLVE_LOG_EVENT_FUNC must be defined before TPTPLog.h is included
#endif

#ifndef RESOLVE_INITIAL_PARAM
#error  RESOLVE_INITIAL_PARAM must be defined before TPTPLog.h is included
#endif

#ifndef TPTP_LOG_SUBCOMPONENT_NAME
#error  TPTP_LOG_SUBCOMPONENT_NAME must be defined before TPTPLog.h is included
#endif

#ifndef TPTP_LOG_INSTANCE_ID
#error  TPTP_LOG_INSTANCE_ID must be defined before TPTPLog.h is included
#endif


/* Macros for logging message with any kind of level (TPTP_SEVERE, TPTP_ERROR, TPTP_WARNING, TPTP_DEBUG, TPTP_INFO)
 *  The level information also should be passed.
 *  There are overloaded macros that take 1-5 parameters alongwith format like printf
 */
#define TPTP_LOG_MSG(p, sev, tptp_log_msg) RESOLVE_LOG_EVENT_FUNC(p)(RESOLVE_INITIAL_PARAM(p) TPTP_LOG_SUBCOMPONENT_NAME(p), TPTP_LOG_INSTANCE_ID(p), __FILE__, __LINE__, sev, tptp_log_msg)

#define TPTP_LOG_MSG1(p, sev, msgFormat, par1)                           \
                                       {	                             \
                                        char tptp_log_msg[TPTP_MAX_MSG_SIZE];      \
                                        sprintf( tptp_log_msg, msgFormat, par1 ); \
                                        RESOLVE_LOG_EVENT_FUNC(p)(RESOLVE_INITIAL_PARAM(p) TPTP_LOG_SUBCOMPONENT_NAME(p), TPTP_LOG_INSTANCE_ID(p), __FILE__, __LINE__, sev, tptp_log_msg); \
                                       }
#define TPTP_LOG_MSG2(p, sev, msgFormat, par1, par2)                     \
                                       {	                             \
                                        char tptp_log_msg[TPTP_MAX_MSG_SIZE];      \
                                        sprintf( tptp_log_msg, msgFormat, par1, par2 ); \
                                        RESOLVE_LOG_EVENT_FUNC(p)(RESOLVE_INITIAL_PARAM(p) TPTP_LOG_SUBCOMPONENT_NAME(p), TPTP_LOG_INSTANCE_ID(p), __FILE__, __LINE__, sev, tptp_log_msg); \
                                       }
#define TPTP_LOG_MSG3(p, sev, msgFormat, par1, par2, par3)               \
                                       {	                             \
                                        char tptp_log_msg[TPTP_MAX_MSG_SIZE];      \
                                        sprintf( tptp_log_msg, msgFormat, par1, par2, par3 ); \
                                        RESOLVE_LOG_EVENT_FUNC(p)(RESOLVE_INITIAL_PARAM(p) TPTP_LOG_SUBCOMPONENT_NAME(p), TPTP_LOG_INSTANCE_ID(p), __FILE__, __LINE__, sev, tptp_log_msg); \
                                       }
#define TPTP_LOG_MSG4(p, sev, msgFormat, par1, par2, par3, par4)         \
                                       {	                             \
                                        char tptp_log_msg[TPTP_MAX_MSG_SIZE];      \
                                        sprintf( tptp_log_msg, msgFormat, par1, par2, par3, par4 ); \
                                        RESOLVE_LOG_EVENT_FUNC(p)(RESOLVE_INITIAL_PARAM(p) TPTP_LOG_SUBCOMPONENT_NAME(p), TPTP_LOG_INSTANCE_ID(p), __FILE__, __LINE__, sev, tptp_log_msg); \
                                       }
#define TPTP_LOG_MSG5(p, sev, msgFormat, par1, par2, par3, par4, par5)   \
                                       {	                             \
                                        char tptp_log_msg[TPTP_MAX_MSG_SIZE];      \
                                        sprintf( tptp_log_msg, msgFormat, par1, par2, par3, par4, par5 ); \
                                        RESOLVE_LOG_EVENT_FUNC(p)(RESOLVE_INITIAL_PARAM(p) TPTP_LOG_SUBCOMPONENT_NAME(p), TPTP_LOG_INSTANCE_ID(p), __FILE__, __LINE__, sev, tptp_log_msg); \
                                       }

/* Macros for logging TPTP_SEVERE message 
*  There are overloaded macros that take 1-5 parameters alongwith format like printf
*/
#define TPTP_LOG_SEVERE_MSG(p, tptp_log_msg) TPTP_LOG_MSG(p, TPTP_SEVERE, tptp_log_msg)
#define TPTP_LOG_SEVERE_MSG1(p, msgFormat, par1) TPTP_LOG_MSG1(p, TPTP_SEVERE, msgFormat, par1)
#define TPTP_LOG_SEVERE_MSG2(p, msgFormat, par1, par2) TPTP_LOG_MSG2(p, TPTP_SEVERE, msgFormat, par1, par2)
#define TPTP_LOG_SEVERE_MSG3(p, msgFormat, par1, par2, par3) TPTP_LOG_MSG3(p, TPTP_SEVERE, msgFormat, par1, par2, par3)
#define TPTP_LOG_SEVERE_MSG4(p, msgFormat, par1, par2, par3, par4) TPTP_LOG_MSG4(p, TPTP_SEVERE, msgFormat, par1, par2, par3, par4)
#define TPTP_LOG_SEVERE_MSG5(p, msgFormat, par1, par2, par3, par4, par5) TPTP_LOG_MSG5(p, TPTP_SEVERE, msgFormat, par1, par2, par3, par4, par5)


/* Macros for logging TPTP_ERROR message 
*  There are overloaded macros that take 1-5 parameters alongwith format like printf
*/
#define TPTP_LOG_ERROR_MSG(p, tptp_log_msg) TPTP_LOG_MSG(p, TPTP_CRITICAL, tptp_log_msg)
#define TPTP_LOG_ERROR_MSG1(p, msgFormat, par1) TPTP_LOG_MSG1(p, TPTP_CRITICAL, msgFormat, par1)
#define TPTP_LOG_ERROR_MSG2(p, msgFormat, par1, par2) TPTP_LOG_MSG2(p, TPTP_CRITICAL, msgFormat, par1, par2)
#define TPTP_LOG_ERROR_MSG3(p, msgFormat, par1, par2, par3) TPTP_LOG_MSG3(p, TPTP_CRITICAL, msgFormat, par1, par2, par3)
#define TPTP_LOG_ERROR_MSG4(p, msgFormat, par1, par2, par3, par4) TPTP_LOG_MSG4(p, TPTP_CRITICAL, msgFormat, par1, par2, par3, par4)
#define TPTP_LOG_ERROR_MSG5(p, msgFormat, par1, par2, par3, par4, par5) TPTP_LOG_MSG5(p, TPTP_CRITICAL, msgFormat, par1, par2, par3, par4, par5)


/* Macros for logging TPTP_WARNING message 
*  There are overloaded macros that take 1-5 parameters alongwith format like printf
*/
#define TPTP_LOG_WARNING_MSG(p, tptp_log_msg) TPTP_LOG_MSG(p, TPTP_WARNING, tptp_log_msg)
#define TPTP_LOG_WARNING_MSG1(p, msgFormat, par1) TPTP_LOG_MSG1(p, TPTP_WARNING, msgFormat, par1)
#define TPTP_LOG_WARNING_MSG2(p, msgFormat, par1, par2) TPTP_LOG_MSG2(p, TPTP_WARNING, msgFormat, par1, par2)
#define TPTP_LOG_WARNING_MSG3(p, msgFormat, par1, par2, par3) TPTP_LOG_MSG3(p, TPTP_WARNING, msgFormat, par1, par2, par3)
#define TPTP_LOG_WARNING_MSG4(p, msgFormat, par1, par2, par3, par4) TPTP_LOG_MSG4(p, TPTP_WARNING, msgFormat, par1, par2, par3, par4)
#define TPTP_LOG_WARNING_MSG5(p, msgFormat, par1, par2, par3, par4, par5) TPTP_LOG_MSG5(p, TPTP_WARNING, msgFormat, par1, par2, par3, par4, par5)


/* Macros for logging TPTP_DEBUG message 
*  There are overloaded macros that take 1-5 parameters alongwith format like printf
*/
#define TPTP_LOG_DEBUG_MSG(p, tptp_log_msg) TPTP_LOG_MSG(p, TPTP_DEBUG, tptp_log_msg)
#define TPTP_LOG_DEBUG_MSG1(p, msgFormat, par1) TPTP_LOG_MSG1(p, TPTP_DEBUG, msgFormat, par1)
#define TPTP_LOG_DEBUG_MSG2(p, msgFormat, par1, par2) TPTP_LOG_MSG2(p, TPTP_DEBUG, msgFormat, par1, par2)
#define TPTP_LOG_DEBUG_MSG3(p, msgFormat, par1, par2, par3) TPTP_LOG_MSG3(p, TPTP_DEBUG, msgFormat, par1, par2, par3)
#define TPTP_LOG_DEBUG_MSG4(p, msgFormat, par1, par2, par3, par4) TPTP_LOG_MSG4(p, TPTP_DEBUG, msgFormat, par1, par2, par3, par4)
#define TPTP_LOG_DEBUG_MSG5(p, msgFormat, par1, par2, par3, par4, par5) TPTP_LOG_MSG5(p, TPTP_DEBUG, msgFormat, par1, par2, par3, par4, par5)


/* Macros for logging TPTP_INFO message 
*  There are overloaded macros that take 1-5 parameters alongwith format like printf
*/
#define TPTP_LOG_INFO_MSG(p, tptp_log_msg) TPTP_LOG_MSG(p, TPTP_INFORMATION, tptp_log_msg)
#define TPTP_LOG_INFO_MSG1(p, msgFormat, par1) TPTP_LOG_MSG1(p, TPTP_INFORMATION, msgFormat, par1)
#define TPTP_LOG_INFO_MSG2(p, msgFormat, par1, par2) TPTP_LOG_MSG2(p, TPTP_INFORMATION, msgFormat, par1, par2)
#define TPTP_LOG_INFO_MSG3(p, msgFormat, par1, par2, par3) TPTP_LOG_MSG3(p, TPTP_INFORMATION, msgFormat, par1, par2, par3)
#define TPTP_LOG_INFO_MSG4(p, msgFormat, par1, par2, par3, par4) TPTP_LOG_MSG4(p, TPTP_INFORMATION, msgFormat, par1, par2, par3, par4)
#define TPTP_LOG_INFO_MSG5(p, msgFormat, par1, par2, par3, par4, par5) TPTP_LOG_MSG5(p, TPTP_INFORMATION, msgFormat, par1, par2, par3, par4, par5)

#endif /* __TPTPLOG_H__ */


