/*******************************************************************************
 * Copyright (c) 2003-2005 IBM, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu Naikawadi Intel - Added various logging MACROS
 *    IBM - Portions of old RAC code (brought over by Vishnu Naikawadi)
 *
 * $Id: TPTPLogUtils.h,v 1.3 2005/10/21 22:18:57 akaylor Exp $ 
 ******************************************************************************/ 


#ifndef __TPTPLOGUTILS_H__
#define __TPTPLOGUTILS_H__

#include "tptp/TPTPTypes.h"
//#include "tptp/tptpLog.h"

#ifdef __cplusplus
	extern "C" {
#endif

tptp_int32 tptp_createLogCBE( tptp_string*  component,
                              tptp_string*  subcomponent,
                              tptp_uint32   instanceId,
                              tptp_string*  filename, 
                              tptp_int32    lineNum, 
                              tptp_int32    severity,
                              tptp_string*  event,
                              tptp_string** cbe );

tptp_int32 tptp_createErrorCmdCBE( tptp_string*  component,
                                   tptp_string*  subcomponent,
                                   tptp_uint32   instanceId,
                                   tptp_int32    severity,
                                   tptp_string*  event,
                                   tptp_string** cbe );

tptp_int32 tptp_normalizeLogMsg( tptp_string*  msg, tptp_string** normalizedMsg );

typedef FILE* tptp_filehandle;

tptp_int32 tptp_createLogFile( tptp_string* filename, tptp_filehandle* f );
tptp_int32 tptp_writeToLogFile( tptp_filehandle f, const tptp_string* cbe, tptp_int32* bytesWritten );
tptp_int32 tptp_closeLogFile( tptp_filehandle f );

#ifdef __cplusplus
	}
#endif


#endif /* __TPTPLOG_H__ */


