/*******************************************************************************
 * Copyright (c) 2005, 2007 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial definition of the header
 *    Hoang M Nguyen, Intel - Updated the definition structure
 *
 * $Id: TPTPMessageHeader.h,v 1.15 2007/09/04 22:34:06 jkubasta Exp $ 
 *******************************************************************************/ 

#ifndef _TPTP_MESSAGE_HEADER_H__
#define _TPTP_MESSAGE_HEADER_H__


#ifdef __cplusplus
extern "C"
{
#endif

/** 
 *   message header specification.
 *   The actual message will follow right after the header.
*/

typedef struct {
	unsigned int magicNumber ;
	unsigned int flags ;       
	unsigned int payLoadLength ;
} tptp_basic_msg_header_t;


typedef struct {
	unsigned int magicNumber ;
	unsigned int flags ;       
	char         md5[16] ;
	unsigned int payLoadLength ;
} tptp_msg_header_with_security_t;


typedef tptp_basic_msg_header_t * tptp_basic_msg_header_ptr_t ;
typedef tptp_msg_header_with_security_t * tptp_msg_header_with_security_ptr_t ;

#define  MD5_PRESENT                0x00000001
#define  CONNECT                    0x01000000
#define  DISCONNECT                 0x02000000
#define  CONNECTION_COMPLETE        0x04000000
#define  CONNECTION_REFUSED         0x08000000
#define  CONNECTION_RECONNECT_REQUEST 0x09000000
#define  CONNECT_DATA               0x10000000
#define  DATA_CONNECTION_COMPLETE   0x20000000
#define  DATA_CONNECTION_REFUSED    0x40000000

#define  SECURITY_REQUIRED        	0x00010000
#define  AUTHENTICATE        		0x00020000
#define  AUTHENTICATION_FAILED     	0x00040000
#define  AUTHENTICATION_SUCCESSFUL 	0x00080000

#define  CONNECT_CONSOLE		    0x00100000
#define  CONSOLE_CONNECT_COMPLETE	0x00200000
#define  CONSOLE_CONNECT_FAILED		0x00400000
#define  CONSOLE_PROCESS_LAUNCHED	0x00800000

/* Byte stream identifier: looks like "Tt" */
#define MAGIC_NUMBER				0x54B674DE

/* the following definition is for flag settings for data connection request */
#define  SEND_DATA                  0x00000001
#define  RECEIVE_DATA               0x00000002


/** connection type */
enum ConnectionType { CONTROL_CHANNEL, DATA_CHANNEL, CONSOLE_CHANNEL } ;


typedef struct {
	/* CONNECT_CONSOLE flag command payload */
	unsigned int  replyConnId ; //Id used for sending a response to CONSOLE_CONNECT
	int      uuidLength ;   // Length if uuid string.
	char     uuid[256] ;    // Unique Id string used to form names of console pipes 
} tptp_console_connect_cmd_t;

typedef struct {
	/* CONSOLE_PROCESS_LAUNCHED flag command payload */
	unsigned int   processConnId ; // connect Id returned in the CONSOLE_CONNECT_COMPLETE response
	PID      processId ; // pid of the process which was launched
} tptp_console_launch_cmd_t;


/** different types of console messages */
enum ConsoleMessageType { TPTP_STDOUT=1, TPTP_STDIN=2, TPTP_STDERR=3 } ;


/** thread's status*/
enum ThreadStatusType { TPTP_IDLE_THREAD, TPTP_RUNNING_THREAD } ;


#ifdef __cplusplus
} /* Ends extern C */
#endif


#endif /* _TPTP_MESSAGE_HEADER_H__ */
