/*******************************************************************************
 * Copyright (c) 2005, 2010 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Hoang M Nguyen, Intel - Initial API and Implementation
 * $Id: TPTPOSCalls.h,v 1.13 2010/01/29 21:05:41 jwest Exp $
 *******************************************************************************/


/**
 *********************************************************
 *
 * @file      tptpOSCalls
 *
 * @brief
 *    This provides a generic interface to OS-specific system calls
 *
 *
 *********************************************************/

#ifndef __TPTPOSCALLS_H
#define __TPTPOSCALLS_H


#include "tptp/TPTPSupportTypes.h"


extern const char OS_SPECIFIC_NAME_SEPARATOR ;


#ifdef __cplusplus
extern "C" {
#endif


char * getGlobalUniqueId() ;


int compareIgnoreCase(const char *pStr1, const char *pStr2) ;


void * loadTheModule(const char *pLibName) ;


/** An optional function for AIX; allows the developer to set the stackSize of the thread. */
#ifdef _AIX
	int  startNewThreadAIXStackSize(RUN_FUNC_TYPE  pFunc, void * pParmBlock, TID *pThreadId, HANDLE *pTheadHandle, int stackSize) ;
#endif

int  startNewThread(RUN_FUNC_TYPE  pFunc, void * pParmBlock, TID *pThreadId, HANDLE *pTheadHandle) ;
int  tptpStartThread(RUN_FUNC_TYPE  pFunc, void * pParmBlock, TID *pThreadId, HANDLE *pTheadHandle) ;


PID  getCurrentlyRunningProcessId() ;

#ifdef MVS
  PID  getCurrentlyRunningThreadId();
#else
  TID  getCurrentlyRunningThreadId() ;
#endif

void printCurrentSysError() ;


void  tptpSleep(int milliseconds) ;

#define UNKNOWN_EXE "unknown"

char *getExecutableName();

#ifdef __cplusplus
}
#endif


#endif /* __TPTPOSCALLS_H*/


