/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Hoang M Nguyen, Intel - Initial API and Implementation
 *
 * $Id: TPTPSupportTypes.h,v 1.5 2005/07/24 08:40:30 hnguyen Exp $
 *******************************************************************************/ 

#ifndef  __TPTP_SUPPORT_TYPES_H__
#define  __TPTP_SUPPORT_TYPES_H__

//-----------------------------------------------
//   Flag for class/function exports (e.g. library external interface)
//-----------------------------------------------
#include "tptp/TPTPUtils.h"

#ifdef _WIN32

	//#include "winsock2.h"	

   //-------------
   // Windows only
   //-------------
	#ifndef TPTP_FUNC_EXPORT
		#define TPTP_FUNC_EXPORT __declspec(dllexport)
	#endif


	typedef DWORD (WINAPI *RUN_FUNC_TYPE) (void *);

	#define THREAD_USER_FUNC_RET_TYPE    DWORD    WINAPI

	typedef DWORD THREAD_ID;


	/** named pipe info */
	#define RA_PIPE_NAMESPACE "\\\\.\\pipe\\IBMAC\\"

#else

   //-------------
   // Linux only (all flavors)
   //-------------
   #ifndef TPTP_FUNC_EXPORT
       #define TPTP_FUNC_EXPORT
   #endif

	#include <pthread.h>
	#include <sys/socket.h>
	#include <sys/types.h>
	#include <unistd.h>
	#include <netdb.h>
	#include <netinet/tcp.h>
	#include <string.h>
	#include <netinet/in.h>
	#include <errno.h>

	typedef void * (*RUN_FUNC_TYPE)(void *);
		
	typedef int THREAD_ID;
	
	typedef void * LPVOID ;
	
	typedef unsigned long       DWORD ;

	
	#define THREAD_USER_FUNC_RET_TYPE void *
	
	#define closesocket(n) close(n)
	
	#define Sleep(n)  tptpSleep(n)

	/** common shared memory key if none could be generated */
	#define TPTP_IPC_COMMON_KEY 0x012db210


	/** named pipe info */
	#define RA_PIPE_NAMESPACE "/tmp/IBMRAC/"
	#define RA_PIPE_NAMESPACE_SHORT "/tmp/IBMRAC"

#endif

#include "tptp/TPTPCommon.h"

#include "tptp/TPTPErrorCode.h"

#include "tptp/TPTPLimits.h"

#include "tptp/TPTPOSCalls.h"


#endif /* __TPTP_SUPPORT_TYPES_H__ */

