/*******************************************************************************
 * Copyright (c) 2005, 2007 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Hoang M Nguyen, Intel - Initial API and Implementation
 *
 * $Id: TPTPSupportUtils.h,v 1.3 2007/09/04 22:34:50 jkubasta Exp $
 *******************************************************************************/ 


/**
 *********************************************************
 *
 * @file      TPTPSupportUtils
 *
 * @brief
 *    This contains common utilities/functions
 *
 *********************************************************/

#ifndef __TPTP_SUPPORT_UTILS_H__
#define __TPTP_SUPPORT_UTILS_H__

#include <stdio.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 *********************************************************
 *                                                       
 * @brief                                                
 *    load a given library
 *
 * @return
 *    The library handler or
 *    NULL if unable to load the library.
 *
 * @note
 *    it returns (void *) to have consistent call interface for all platforms.
 *
 *********************************************************/
void * loadThisLib(const char *pLibName) ;


/**
 *********************************************************
 *                                                       
 * @brief                                                
 *    generate a unique id string
 *
 * @return
 *    The address of the UUID string
 *    NULL if unable to generate the UUID
 *
 * @note
 *    The caller is responsible to free the returned string with free(char *) function
 *********************************************************/
char * generateUUID() ;

unsigned char* writeUINTToBuffer(unsigned char *buffer, unsigned int uintData);
unsigned char* readUINTFromBuffer(unsigned char *buffer, unsigned int *uint);
unsigned char* readStringFromBuffer(unsigned char *buffer, char** str);

#ifdef __cplusplus
}
#endif

#endif /* __TPTP_SUPPORT_UTILS_H__ */


