/*******************************************************************************
 * Copyright (c) 2005, 2009 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Andy Kaylor, Intel - Initial re-implementation of Agent Controller
 *
 * $Id: TPTPTypes.h,v 1.16 2009/07/10 00:11:28 jwest Exp $
 *******************************************************************************/

#ifndef __TPTP_TYPES_H__
#define __TPTP_TYPES_H__

#include <stdio.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifdef _WIN32
	// should use DWORD, but that requires inclusion of a windef.h
	// at a minimum, and that results in a cascade of type problems.
	typedef unsigned long PID;
#else
#ifndef _RACOMM_H_
	#include <sys/types.h>
	typedef pid_t PID;
#endif
#endif
#define TPTP_INVALID_PID 0

typedef signed char	        tptp_int8;
typedef unsigned char 		tptp_uint8;
typedef short 				tptp_int16;
typedef unsigned short 		tptp_uint16;
typedef int           		tptp_int32;
typedef unsigned int  		tptp_uint32;
#if (__WORDSIZE == 64) || defined(_WIN64) || (defined(_AIX) && defined(__64BIT__))
typedef unsigned long 		tptp_uint64;
typedef long          		tptp_int64;
#else
//typedef unsigned double 	tptp_uint64;
typedef double         		tptp_int64;
#endif

typedef struct
{
	tptp_uint32   objectID;
	void*         data;
} tptp_object;

typedef char tptp_string;


typedef enum
{
	TPTP_LOGFORMAT_CBE = 0,
	TPTP_LOGFORMAT_SIMPLE = 1,
} tptp_loggingFormat;

//tptp_string -- data element of the struct contains data terminated by a null string
//the bufsize is the number of bytes of the "data" element. Example: on Windows the bufsize will
//be the strlen of the data, the strlen returns the number of bytes used irrespective of
//the characters being single byte or multi-byte characters 
/*
typedef struct {
	tptp_int32 bufsize;
	char *data;
}tptp_string;
*/

#ifdef __cplusplus
}
#endif
#endif /* __TPTP_TYPES_H__ */
