/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Andy Kaylor, Intel - Initial re-implementation of Agent Controller
 *
 * $Id: Transport.h,v 1.2 2005/06/02 00:56:46 vnaikawadi Exp $
 *******************************************************************************/ 

/**********************************************************************
 *																	  *
 * Transport.h : Common definitions for the interface between the     *
 *				 Agent Controller and the various transport layers.   *
 *																	  *
 **********************************************************************/

#ifndef __TRANSPORT_H__
#define __TRANSPORT_H__

#include "tptp/TPTPTypes.h"
#include "tptp/MsgPipeline.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
 *********************************************************
 *
 * @brief
 *    common interface to instantiate a transport layer object
 *
 * @return
 *    0 - Success
 *    nonzero - Error.
 *********************************************************/
tptp_int32 createTransportListener( tptp_object* cmo, transport_layer_data_t * pTransportData, tptp_object* tlo ); 


/**
 *********************************************************
 *
 * @brief
 *    common interface to destroy a transport layer object
 *
 * @return
 *    0 - Success
 *    nonzero - Error.
 *********************************************************/
tptp_int32 destroyTransportListener( tptp_object* tlo ); 


/**
 *********************************************************
 *
 * @brief
 *    common interface to set the function and data block 
 * for forwarding messages
 *
 * @return
 *    0 - Success
 *    nonzero - Error.
 *********************************************************/
tptp_int32 setProcessMessageFunc(tptp_object* tlo, tptp_object* nexto, processMessage_ptr_t func ); 


/**
 *********************************************************
 *
 * @brief
 *    common interface to start an underlying transport mechanism
 *
 * @return
 *    0 - Success
 *    nonzero - Error.
 *********************************************************/
tptp_int32 startTransportListener( tptp_object* tlo ); 


/**
 *********************************************************
 *
 * @brief
 *    common interface to stop the transport mechanism
 *
 * @return
 *    0 - Success
 *    nonzero - Error.
 *********************************************************/
tptp_int32 stopTransportListener(tptp_object* tlo);


/**
 *********************************************************
 *
 * @brief
 *    common interface to terminate the given connection
 *
 * @return
 *    0 - Success
 *    nonzero - Error.
 *********************************************************/
tptp_int32 terminateConnection(tptp_object* tlo, tptp_uint32 connectionID);


/**
 *********************************************************
 *
 * @brief
 *    send a given message to the given destination (identified by connection id)
 *
 * @return
 *    0 - Success
 *    nonzero - Error.
 *********************************************************/
tptp_int32 sendMessage(tptp_object* tlo, tptp_uint32 connectionID, tptp_uint32 size, tptp_string* pCmdBlock) ;


/**
 *********************************************************
 *
 * @brief
 *    send a given data block to the given destination (identified by connection id)
 *
 * @return
 *    0 - Success
 *    negative - Not supported
 *    positive - Error code
 *********************************************************/
tptp_int32 sendData(tptp_object* tlo, tptp_uint32 connectionID, tptp_uint32 size, void* pDataBlock);


/**
 *********************************************************
 *
 * @brief
 *    set up the data path between the source and destination
 *
 * @return
 *    0 - Success
 *    negative - Not supported
 *    positive - Error code
 *********************************************************/
tptp_int32 setIncomingDataFunc( tptp_object* tlo, tptp_uint32 connectionID, tptp_uint32 partnerID, tptp_object* partner, sendData_ptr_t newDataFunc ) ;


/**
 *********************************************************
 *
 * @brief
 *    terminate a given data connection
 *
 * @return
 *    0 - Success
 *    negative - Not supported
 *    positive - Error code
 *********************************************************/
tptp_int32 terminateDataConnection(tptp_object* tlo, tptp_uint32 connectionID);

#ifdef __cplusplus
}
#endif

#endif /* __TRANSPORT_H__ */
