/*******************************************************************************
 * Copyright (c) 2005, 2008 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Hoang M Nguyen, Intel - Initial API and Implementation
 *
 * $Id: TransportOSCalls.h,v 1.7 2008/06/16 20:58:04 jkubasta Exp $
 *
 *******************************************************************************/



#ifndef TransportOSCalls_H
#define TransportOSCalls_H


#include "tptp/TPTPSupportTypes.h"


#ifdef __cplusplus
extern "C" {
#endif


/**
 *********************************************************
 *
 * @brief
 *    required initialization before using socket library.
 *    This also checks for socket DLL version.
 *
 * @return
 *    0 - Success
 *    nonzero - Error.
 *********************************************************/
int initForSocketCalls() ;


/**
 *********************************************************
 *
 * @brief
 *    set a given handle for child process inheritance
 *
 * @return
 *    0 - Error
 *    nonzero - Success
 *
 * @note
 *    nonzero means success
 *********************************************************/
int setHandleInherited(HANDLE handle) ;


/**
 *********************************************************
 *
 * @brief
 *    return indicator whether a given socket is valid or not
 *
 * @return
 *    nonzero - Valid
 *    zero - Invalid
 *********************************************************/
int isSocketValid(SOCKET sock) ;


/**
 *********************************************************
 *
 * @brief
 *    print out info about a given socket request
 *
 * @return
 *    0 - always
 * IPV4-ONLY
 *********************************************************/
int printSocketRequest(SOCKET sock, struct sockaddr_in * pRequester) ;


/**
 *********************************************************
 *
 * @brief
 *    Read from a given sock and place the incoming data
 *    into the given buffer
 *
 * @return
 *    0 - Success
 *    nonzero - Error.
 *********************************************************/
int  readFromSocket(SOCKET sock,
					char *buffer,
					int byteCount,
					int *byteRead);


/**
 *********************************************************
 *
 * @brief
 *    close the given socket connection
 *
 * @return
 *    0 - Success
 *    nonzero - Error.
 *********************************************************/
int closeThisSocket(SOCKET sock) ;

/** IPV4-ONLY */
void extractAddressFromSockAddr(struct sockaddr_in *connection, unsigned char *address);




#ifdef __cplusplus
}
#endif


#endif


