/*******************************************************************************
 * Copyright (c) 2005, 2008 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Hoang M Nguyen, Intel - Initial API and Implementation
 *
 * $Id: TransportSupport.h,v 1.12 2008/06/16 20:58:05 jkubasta Exp $
 *
 *******************************************************************************/ 



#ifndef TransportSupport_H
#define TransportSupport_H

#include <stdio.h>

#include "tptp/TPTPSupportTypes.h"

#include "tptp/TPTPMessageHeader.h"

#include "tptp/TransportOSCalls.h"

#include "tptp/TransportSupportSocket.h"

#include "tptp/TransportSupportSharedMem.h"

#include "tptp/TransportSupportNamedPipe.h"


#ifdef __cplusplus
extern "C" {
#endif



/**
 *********************************************************
 *
 * @brief
 *    Add the basic message header to the message data/command before sending
 *
 * @return
 *    0 - success
 *        buffer will point to the newly built command with the header
 *        bufferLength will contain the new length
 *
 *********************************************************/
int addBasicMsgHeader(char * pCmdBlock, int cmdSize, char **pBuffer, int *pBufferLength, unsigned int flags) ;


/**
 *********************************************************
 *
 * @brief
 *    Print out the content of the message envelop
 *
 * @return
 *    0 - success
 *********************************************************/
#ifndef DISPLAY_NOLOG_MSGS
#define printThisEnvelope( msg )
#else
int printThisEnvelope(tptp_basic_msg_header_ptr_t pMsg) ;
#endif


/**
 *********************************************************
 *
 * @brief
 *    extract and return the connection id from the CONNECT_COMPLETE response
 *
 * @return
 *    the connection id
 *********************************************************/
int getConnectionId(tptp_basic_msg_header_t *pMsg) ;


/**
 *********************************************************
 *
 * @brief
 *    check for validity of the given block and the given block id.
 *
 * @return
 *    true (non-zero) if the block is valid (e.g. match the given id)
 *    false (zero) if the block is not valid
 *********************************************************/
int isValidTPTPBlock(tptp_object * pObj, tptp_uint32 tptpBlockId) ;

BOOL tptp_checkHost(network_list_t *list, unsigned char *address);

SOCKET connectToHostWithAddr(struct sockaddr_storage *addr);

BOOL tptp_checkHostIPv6(network_list_t *list, struct sockaddr_storage * addr);

#ifdef __cplusplus
}
#endif


#endif


