/*******************************************************************************
 * Copyright (c) 2005, 2007 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Hoang M Nguyen, Intel - Initial API and Implementation
 *
 * $Id: TransportSupportSharedMem.h,v 1.14 2007/04/09 17:01:25 gnagarajan Exp $
 *
 *******************************************************************************/ 



#ifndef transportSupportSharedMem_H
#define transportSupportSharedMem_H

#include "tptp/TPTPSupportTypes.h"


/* main thread data block */
typedef struct {
	LPVOID     pRamboBlock ;
} mem_map_block_t ;  

typedef mem_map_block_t * mem_map_block_ptr_t ;


/* written buffer format */
typedef struct  buffer_format {
	int                 status ;
	int                 currentLength ;
	char                firstChar ;
} buffer_format_t ;

typedef buffer_format_t * buffer_format_ptr_t ;



/* Type for pointer to data processing routine */
typedef int (*TPTPDataProcessingFunc)(
    void *pData,
    int dataLen,
    void *pArgs
	);



#ifdef __cplusplus
extern "C" {
#endif

/** Validate whether the shared memory size requested is below the system define
d max value or not
 *
 * @param size - the requested shared memory segment size
 */
extern int validateSystemShmMax(int size);

/**
 *********************************************************
 *
 * @brief
 *    Destroy (free) the given IPC memory resource.
 *
 * @return
 *    0 - Success
 *    nonzero - Error.
 *********************************************************/
int ipcMemDestroy(mem_map_block_ptr_t pBlockInfo) ;


/**
 *********************************************************
 *
 * @brief
 *    Create an IPC memory resource.
 *
 * @param  pMemName
 *              the name of shared memory resource
 *
 * @param  pBlockInfo
 *              the info of the returned shared memory map
 *
 * @return
 *    0 - Success
 *    nonzero - Error.
 *********************************************************/
int ipcMemCreate(
      const char * pMemName,
	  mem_map_block_ptr_t pBlockInfo,
	  tptp_uint32 requestedSize );


/**
 *********************************************************
 *
 * @brief
 *    Open an IPC memory resource.
 *
 * @param  pMemName
 *              the name of shared memory resource
 *
 * @param  pBlockInfo
 *              the info of the returned shared memory map
 *
 * @return
 *    0 - Success
 *    nonzero - Error.
 *********************************************************/
int ipcMemOpen(
      const char * pMemName,
	  mem_map_block_ptr_t pBlockInfo) ;


int isMemOpen (mem_map_block_ptr_t pBlockInfo);

/**
 *********************************************************
 *
 * @brief
 *    Write given data to the given IPC memory resource.
 *
 * @param  pBlockInfo
 *              the info of the shared memory map to write to
 *
 * @return
 *    0 - Success
 *    nonzero - Error.
 *********************************************************/

int ipcMemWrite(
      char * pFromBuffer,
      int bufferLength,
	  mem_map_block_ptr_t pBlockInfo) ;


/**
 *********************************************************
 *
 * @brief
 *    Write given data to the given IPC memory resource.
 *
 * @param  pBlockInfo
 *              the info of the shared memory map to write to
 *
 * @return
 *    0 - Success
 *    nonzero - Error.
 *********************************************************/

int ipcMemWriteWithDIME(
      char * pFromBuffer,
      int bufferLength,
      char * dimeHeader,
      int dimeLength,
	  mem_map_block_ptr_t pBlockInfo) ;


/**
 *********************************************************
 *
 * @brief
 *    Write given data to the given IPC memory resource.
 *
 * @param  pBlockInfo
 *              the info of the shared memory map to write to
 *
 * @return
 *    0 - Success
 *    nonzero - Error.
 *********************************************************/

int ipcMemWriteRaw(
      char * pFromBuffer,
      int bufferLength,
	  mem_map_block_ptr_t pBlockInfo) ;



/**
 *********************************************************
 *
 * @brief
 *    Set up data processing and monitor data for the given shared memory block
 *
 * @param  pBlockInfo
 *              the info of the shared memory map to monitor
 *
 * @param  pDataProcessor
 *              the function to be called whenever data are available
 *
 * @param  pArgs
 *              any paramater need to be passed along with the data to the function
 *
 * @return
 *    0 - Success
 *    nonzero - Error.
 *********************************************************/
int  ipcFlushToFunc(mem_map_block_ptr_t pBlockInfo,
      TPTPDataProcessingFunc pDataProcessor,
	  void *pArgs ) ;

/**
 *********************************************************
 *
 * @brief
 *    Set up data processing and monitor data for the given shared memory block
 *
 * @param  pBlockInfo
 *              the info of the shared memory map to monitor
 *
 * @param  fd
 *              file descriptor. (socket or file)
 * @param  desc
 *              type of file decriptor
 *
 * @return
 *    0 - Success
 *    nonzero - Error.
 *********************************************************/
int  ipcFlushToFD(mem_map_block_ptr_t pBlockInfo,
      int fd,
      int desc);


/**
 *********************************************************
 *
 * @brief
 *    Stop reading from the given IPC memory resource.
 *
 * @param  pBlockInfo
 *              the info of the shared memory map to stop reading
 *
 * @return
 *    0 - Success
 *    nonzero - Error.
 *********************************************************/

int ipcStopFlushing(mem_map_block_ptr_t pBlockInfo);
int ipcStopFlusher(mem_map_block_ptr_t pBlockInfo);

int ipcCloseMem(mem_map_block_ptr_t pBlockInfo);
int ipcMemDetach (mem_map_block_ptr_t);

#ifdef __cplusplus
}
#endif


#endif
