/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Ramesh Vishwanath,Intel - Initial API and implementation
 *
 * $Id: Variable.h,v 1.1 2005/08/20 19:27:12 vnaikawadi Exp $ 
 *******************************************************************************/ 

#ifndef __Variable_H__
#define __Variable_H__

#include "tptp/TPTPExport.h"
#include "tptp/agents/IBaseAgent.h"
#include "tptp/TransportSupport.h"
#include "tptp/TPTPSupportTypes.h"
#include "tptp/TPTPUtils.h"

class TPTP_CLASS_EXPORT Variable {
	
	private : 
		int id;
		char *name;
		char *description;
		int type;
		int read_access;
		int write_access;
		char* xsdTypeNameSpace;
		char* xsdTypeNCName;
		void* value;
			
	public :

		/* Constructors */
		Variable();
		Variable(int id, char* name, char* description, int type, int read_access, int write_access, char* xsdTypeNameSpace, char* xsdTypeNCName, void *value );

		/* Element Readers */
		int getID();
		char* getName();
		char* getDescription();
		int getType();
		int getReadAccess();
		int getWriteAccess();
		char* getNameSpace();
		char* getNCName();
		void* getValue();
		
		/* Element Modifiers */
		int setID(int id);
		int setName(char* name);
		int setDescription(char* description);
		int setType(int type);
		int setReadAccess(int readAccess);
		int setWriteAccess(int writeAccess);
		int setNameSpace(char* xsdTypeNameSpace);
		int setNCName(char* xsdTypeNCName);
		int setValue(void* value);

		static char* createVariableString(Variable* var);
		
};


#endif //_Variable_H

