/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Ramesh Vishwanath,Intel - Initial API and implementation
 *
 * $Id: VariableGroup.h,v 1.1 2005/08/20 19:27:12 vnaikawadi Exp $ 
 *******************************************************************************/ 


#ifndef __Variable_Group_H__
#define __Variable_Group_H__


#include "Variable.h"

class TPTP_CLASS_EXPORT VariableGroup {

	private : 
		int id;
		char* name;
		char* description;
		tptp_list_t subGroups;
		tptp_list_t varList;

	public : 

		VariableGroup();
		~VariableGroup();
		VariableGroup(int id, char* name, char* description, VariableGroup* subGroup, Variable* variable);
		
		/* Element Readers */
		int getID();
		char* getName();
		char* getDescription();
		tptp_list_t* getSubGroups();
		tptp_list_t* getVariableList();
		Variable* getVariable(int varID);
		
				
		/* Element Modifiers */
		int setID(int id);
		int setName(char* name);
		int setDescription(char* description);
		int setSubGroup(VariableGroup* subGroup);
		int addSubGroup(VariableGroup* subGroup);
		int addVariable(Variable* varNode);
		int setVariable(Variable* varNode);
		int setSubGroupList(tptp_list_t* list);
		int setVariableList(tptp_list_t* list);

		static char* createVarGroupString(VariableGroup* varGroup);
};


#endif

