/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi,Intel - Initial API and implementation
 *
 * $Id: BaseCollectorImpl.h,v 1.5 2005/09/30 01:16:42 kcallaghan Exp $ 
 *******************************************************************************/ 

#ifndef __BASECOLLECTORIMPL_H__
#define __BASECOLLECTORIMPL_H__

#include "tptp/TPTPExport.h"
#include "tptp/agents/IBaseCollector.h"
#include "tptp/agents/EventProviderImpl.h"
#include "tptp/agents/DataProviderImpl.h"
#include "tptp/agents/VariableProvider.h"


class TPTP_CLASS_EXPORT BaseCollectorImpl : public virtual BaseAgentImpl, public IBaseCollector, public EventProviderImpl, public DataProviderImpl, public VariableProvider
{

	private:
		int agentState;

	public:
		BaseCollectorImpl(char* name);
		virtual ~BaseCollectorImpl();


		virtual int run(CmdBlock* cmd);
		virtual int pause(CmdBlock* cmd);
		virtual int resume(CmdBlock* cmd);
		virtual int cancel(CmdBlock* cmd);
		virtual int stop(CmdBlock* cmd);
		virtual int snapshot(CmdBlock* cmd);
		virtual int getData(CmdBlock* cmd);

		virtual int processCommand(CmdBlock* cmdBlock);

		int getState(CmdBlock* cmd);

};

#endif /* __BASECOLLECTORIMPL_H__ */

