/*******************************************************************************
 * Copyright (c) 2005, 2007 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi,Intel - Initial API and implementation
 *
 * $Id: DataProviderImpl.h,v 1.18 2007/04/13 15:58:13 jkubasta Exp $ 
 *******************************************************************************/ 

#ifndef __DataProviderImpl_H__
#define __DataProviderImpl_H__


#include "tptp/TPTPExport.h"

#include "tptp/TPTPSupportUtils.h"
#include "tptp/TPTPOSCalls.h"
#include "tptp/agents/IDataProvider.h"
#include "tptp/agents/BaseAgentImpl.h"
#include "tptp/dime.h"

// buffer length for the commands
#define COMMAND_BUFFER_LENGTH 1024

//buffer length for the data
#define DATA_BUFFER_LENGTH 4096


class CmdBlock;



typedef struct
{
	int clientid;
	int clientDataConnID;
	int agentDataConnID;
	int type;
	int contextID;
	int bindContextID;
	mem_map_block_t agentMemBlockInfo;
	mem_map_block_t dataConnMemBlockInfo;

	bool  _isEstablished ;
	bool  _isReleased ;
	bool  _flushingFinished ;

	char dataConnUUID[128];
	char agentConnUUID[128];
	void * pObj ;

	/* buffers for processing the data read from shared memory */
	int _currentHeaderOffset;
	int _currentBufferSize;
	int _bytesWritten;
	DIME_HEADER_PTR_T _dimeMessageHeader;
	char _binaryForwardBuffer[DATA_BUFFER_LENGTH];
	char _messageHeader[DATA_BUFFER_LENGTH];
	char sendBuffer[DATA_BUFFER_LENGTH];
}  tptp_data_conn_t;



class TPTP_CLASS_EXPORT DataProviderImpl : public IDataProvider, public virtual BaseAgentImpl
{
	private:
				
		mem_map_block_t serverMemBlockInfo ;
		mem_map_block_t agentMemBlockInfo ;
		mem_map_block_t dataConnMemBlockInfo ;
		char *dataConnectionUUID;

		tptp_list_t dataConnectionsList;
		Lock_t dataConnListLock;	//mutex used by data connection list read/write threads	

		int sendCONNECT_DATACommand(char *pUniqueId, int flags);

		int loadMessageHeader(tptp_data_conn_t *ccB, char data[], int offset, int limit);
		int loadMessageHeaderDetails(tptp_data_conn_t *ccB, char data[], int offset, int limit);
		long getMessageLength(tptp_data_conn_t *ccB);		

		int purgeConnectionList();
		int releaseDataConn(tptp_data_conn_t* dataConn);
		int sendDisconnectCommand(tptp_data_conn_t* dataConn);

	public:


		DataProviderImpl(char* name);

		~DataProviderImpl();

		tptp_data_conn_t* getDataConnection(int clientID);


		//TPTP AGENT API - Implemented by BaseAgentImpl
		virtual int sendData(int destinationID, char buffer[], int bufferLength);
		virtual int sendData(int destinationID, char buffer[], int bufferLength, DIME_HEADER_PTR_T dimeHeader, int dimeHeaderLength);


		//TPTP AGENT API
		virtual int receiveData(int sourceID, char buffer[], int bytesRead, DIME_HEADER_PTR_T dimeHeader)=0;

		
		virtual int establishDataPath(int dataConnectionID, int dataChannelType, int destinationID, int contextID);

		virtual int releaseDataPath(int dataConnectionID);

		virtual void removeClient(tptp_int32 clientID);
		

		int connectionsBound(int contextID);


		int connectionsBindError(int contextID, int error);


		static THREAD_USER_FUNC_RET_TYPE handleSharedMemMsg(void* pRequestBlock);


		int processDataProviderCommands(CmdBlock* cmd);

		int processData(int clientid, char data[], int offset, int limit);


		int doEstablish(char *buffer, int dataLen, tptp_data_conn_t *pConn) ;
};

#endif /* __DataProviderImpl_H__ */

