/*******************************************************************************
 * Copyright (c) 2005, 2006 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi,Intel - Initial API and implementation
 *
 * $Id: EventProviderImpl.h,v 1.5 2006/02/10 18:55:51 koleary Exp $ 
 *******************************************************************************/ 

#ifndef __EventProviderImpl_H__
#define __EventProviderImpl_H__


#include "tptp/TPTPExport.h"

#include "tptp/agents/BaseAgentImpl.h"

#include "tptp/agents/IEventProvider.h"
#include "tptp/TPTPUtils.h"
#include "tptp/TPTPCommon.h"

#define BUFFER_LENGTH 1024

typedef struct
{
	char eventInterfaceID[_MAX_PATH];
	int listenerID;
	int destID;
}  tptp_listener_t;




class TPTP_CLASS_EXPORT EventProviderImpl : public IEventProvider, public virtual BaseAgentImpl
{
	private:
		//List of listeners that wish to be notified of events
		tptp_list_t eventListenerList;

	public:


		EventProviderImpl(char *name) : BaseAgentImpl(name)
		{
			tptp_list_init( &eventListenerList );
		}



		~EventProviderImpl()
		{
			tptp_list_clear( &eventListenerList );
		}


		//TPTP AGENT API - Implemented by BaseAgentImpl
		virtual int addEventListener(CmdBlock* cmd);


		virtual int removeEventListener(CmdBlock* cmd);


		void sendEventNotifications(CmdBlock* cmd);

		int processEventProviderCommands(CmdBlock* cmd);



};

#endif /* __EventProviderImpl_H__ */

