/*******************************************************************************
 * Copyright (c) 2005, 2007 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 *
 *******************************************************************************/ 

#ifndef  FileTransferAgent_H
#define  FileTransferAgent_H

#include <stdio.h>

#include "BaseCollectorImpl.h"
#include <iostream>
#include "tptp/TPTPCommon.h"
#include "tptp/TPTPTypes.h"
#include "tptp/TPTPUtils.h"

#define FILE_TRANSFER_ERROR	1
#define FILE_NOT_FOUND 		2
#define FILE_READ_ERROR		3

using namespace std;


typedef struct {
	char* name;
	FILE* fp;
	Semaphore_t *semaphore;
} tptp_file_t;

class FileTransferAgent : public BaseCollectorImpl
{

	private:
		tptp_int32 processGetFileRequest(CmdBlock* cmdBlock);
		tptp_int32 processPutFileRequest(CmdBlock* cmdBlock);
		tptp_int32 processDeleteFileRequest(CmdBlock* cmdBlock);

		tptp_int32 MapCommandNameToID(char* cmdName);
		tptp_int32 MapInterfaceNameToID(char* interfaceName);
		tptp_int32 sendFileData(tptp_int32 destinationID, char buffer[], tptp_int32 bufferLength, tptp_int32 recType, char *fileName);
		void sendError(tptp_int32 destinationID, char *fileName, int errCode);
		tptp_list_t fileOpList;
		Lock_t fileOpListLock;
		tptp_int32 findFileRecordByName(const char *fileName, tptp_file_t *fileRec);
		tptp_file_t*  findFileRecordByName(const char *fileName);
	public:

		FileTransferAgent(char* agentName);
		~FileTransferAgent();
		tptp_int32 createAndGetFile(tptp_int32 clientId, char *localFile, char *remoteFile);
		tptp_int32 openAndSendFile(tptp_int32 clientId, char *localFile, char *remoteFile);

		tptp_int32 getFile(CmdBlock* cmdBlock);
		tptp_int32 putFile(CmdBlock* cmdBlock);
		tptp_int32 deleteFile(CmdBlock* cmdBlock);

		virtual tptp_int32 processCommand(CmdBlock* cmdBlock);
		virtual tptp_int32 receiveData(tptp_int32 sourceID, char buffer[], tptp_int32 bytesRead, DIME_HEADER_PTR_T dimeHeader);


		void initializeFileTransfer(char *fileName, FILE *fp);
		void waitForFileComplete(char *fileName);

};

#endif

