/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi,Intel - Initial API and implementation
 *
 * $Id: IBaseCollector.h,v 1.2 2005/06/30 19:27:01 vnaikawadi Exp $ 
 *******************************************************************************/ 

#ifndef __IBASECOLLECTOR_H__
#define __IBASECOLLECTOR_H__


#include "tptp/TPTPExport.h"
#include "tptp/agents/BaseAgentImpl.h"

class TPTP_CLASS_EXPORT IBaseCollector
{

	public:
		//TPTP COLLECTOR API - BaseCollectorImpl provides
		//implementation for the following
		virtual int run(CmdBlock* cmd)=0;
		virtual int pause(CmdBlock* cmd)= 0;
		virtual int resume(CmdBlock* cmd)=0;
		virtual int cancel(CmdBlock* cmd)=0;
		virtual int stop(CmdBlock* cmd)=0;
		virtual int snapshot(CmdBlock* cmd)=0;
		virtual int getData(CmdBlock* cmd)=0;
		virtual int getState(CmdBlock* cmd)=0;		
};

#endif /* __IBASECOLLECTOR_H__ */
