/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Ramesh Vishwanath,Intel - Initial API and implementation
 *
 * $Id: VariableProvider.h,v 1.4 2005/09/30 01:16:42 kcallaghan Exp $ 
 *******************************************************************************/ 


#ifndef __Variable_Provider_H__
#define __Variable_Provider_H__

/* Variable Provider Definitions */
#include "tptp/agents/BaseAgentImpl.h"
#include "tptp/agents/IEventProvider.h"
#include "tptp/TPTPUtils.h"
#include "tptp/TPTPCommon.h"
#include "tptp/VariableGroup.h"

#define VAR 0
#define VARGRP 1 

typedef struct{
	Variable* var;
	VariableGroup* varGroup;
	int toggle; 	// toggle =0 implies variable, toggle=1 implies variablegroup
}tptp_varlist_t;

class TPTP_CLASS_EXPORT VariableProvider:public virtual BaseAgentImpl
{

	private :
		tptp_list_t agent_Varlist;
		//virtual int checkWritePermission(const int requesterId);
		//virtual int checkReadPermission(const int requesterId);

	protected :
		virtual Variable* getVariable(int varID);
		virtual VariableGroup* getVariableGroup(int varGroupID);
		virtual int setVariable(Variable* var);
		virtual int setVariableGroup(VariableGroup* varGroup);
		virtual int addVariable(Variable* var);
		virtual int addVariableGroup(VariableGroup* varGroup);
		
	public :
	       	
		VariableProvider(char* name);
		~VariableProvider();
		virtual int listVariables(CmdBlock* cmdBlock);
		virtual int listVariableGroups(CmdBlock* cmdBlock);
		virtual int getVariable(int varID, CmdBlock* cmdBlock);
		virtual int getVariableGroup(int varGroupID, CmdBlock* cmdBlock);
		virtual int setVariable(Variable* varNode, CmdBlock* cmdBlock);
		virtual int setVariableGroup(VariableGroup* varGrp, CmdBlock* cmdBlock);
		virtual int processVariableProviderCommands(CmdBlock* cmd);
		
};

#endif


