/*******************************************************************************
 * Copyright (c) 2005, 2009 Intel Corporation, IBM.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial API and Implementation (Based on the Java
 *                                API implementation by IBM)
 *
 * $Id: Agent.h,v 1.15 2009/04/14 20:33:36 jwest Exp $
 *
 *******************************************************************************/ 


#ifndef  Agent_H
#define  Agent_H

#include "tptp/ACFlags.h"
#include "tptp/client/ICommandHandler.h"
#include "tptp/client/INode.h"
#include "tptp/client/AgentController.h"
#include "tptp/Variable.h"
#include "tptp/VariableGroup.h"



namespace TPTP
{
	namespace Client
	{
		class AgentController;

		class AgentCommandHandler : public ICommandHandler
		{
			private:				
				CommandElement* responseCommand;

			protected:
				int responseReceived;
				Semaphore_t responseReceivedSem;

			public:
				AgentCommandHandler();
				virtual ~AgentCommandHandler();
				int getResponseReceived();
				CommandElement* getResponseCommand();
				Semaphore_t* getResponseReceivedSem();
				virtual void incomingCommand(INode* node, CommandElement* command);
		};

		class TPTP_CLASS_EXPORT Agent
		{
			private:
				int _agentId;
				char* _agentName;
				int dataConnectionID;
				int dataDirection;
				int _agentTokenID;
				long _agentProcessID;

			//protected:
				AgentController* _acProxy;				
			public:
				Agent();
				Agent(int id, char* name);
				Agent(char* name);
				~Agent();

				char* getAgentName();

				void setAgentName(char* agentName);

				int getAgentID();

				void setAgentID(int agentID);

				int getAgentTokenID();

				void setAgentTokenID(int agentTokenID);

				long getAgentProcessID();

				void setAgentProcessID(long agentProcessID);

				/* Associates this Agent with the AgentControllerProxy
				 * This call is required currently. But the actual API will do this automatically
				 * in the  getAgent() method of AgentControllerProxy and will return the instance of Agent instead of
				 * AgentID */
				void setACProxy(AgentController* acProxy);

				/* TPTP CLIENT API - Sends a command to the agent
				 * This internally calls the sendCommand() of AgentControllerProxy Class */
				void sendCommand(char* cmd, ICommandHandler* handler);


				void releaseAgent();

				bool requestControl(int flags);

				void releaseControl();

				/* TPTP CLIENT API
				 *
				 * Adds the listner to events that belong to a specific event interface 
				 * Returns the listener id.
				 */
				long addEventListener(char* interfaceid,  ICommandHandler* listener);

				/* TPTP CLIENT API
				 * Removes the listener to events from a specific interface
				 * 
				 */
				void removeEventListener(char* interfaceid, long listenerid);


				/* 
				 * This sends command to establish the data path between the client application
				 * and the collector running on the target machine 
				 * Waits until a confirmation message received from the Collector 
				 */
				//virtual void startMonitoring(int dataConnectionID);

				/* TPTP CLIENT API
				 * Adds the Data Processor object passed as second parameter as listener
				 * of data coming over the data connection
				 */
				virtual int addDataListener(IDataProcessor* dataProcessor);

				/* TPTP CLIENT API
				 * Adds the Data Processor object passed as second parameter as listener
				 * of data coming over the data connection
				 */
				virtual int removeDataListener(IDataProcessor* dataProcessor);

				/* TPTP CLIENT API
				 * Creates a data connection between the Client application and Agent Controller 
				 * 
				 */
				int createDataConnection(int direction);


				/*
				 * Destroys a data connection between the Client application and Agent Controller 
				 * Returns the data connection id received from AC
				 */
				int destroyDataConnection();


				virtual int sendData(char buffer[], int bufferLength);

				virtual int sendData(char buffer[], int bufferLength, char dimeHeader[], int dimeLength);


				//Agent Variable Interface
				virtual int listVariables();
				virtual int listVariableGroups();
				virtual Variable* getVariable(int varID);
				virtual VariableGroup* getVariableGroup(int varGroupID);
				virtual int setVariable(Variable* varNode);
				virtual int setVariableGroup(VariableGroup* varGrp);

		};

	}

}



#endif


