/*******************************************************************************
 * Copyright (c) 2005, 2006 Intel Corporation, IBM.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial API and Implementation (Based on the Java
 *                                API implementation by IBM)
 *
 * $Id: AgentController.h,v 1.9 2006/02/10 19:54:15 vnaikawadi Exp $
 *
 *******************************************************************************/ 



#ifndef  AgentController_H
#define  AgentController_H

#include "tptp/TPTPExport.h"
#include "tptp/client/INode.h"
#include "tptp/client/IProcess.h"
#include "tptp/client/ICommandHandler.h"
#include "tptp/client/Agent.h"
#include "tptp/TPTPUtils.h"
#include "tptp/ACFlags.h"
#include "tptp/TPTPCommon.h"
#include "tptp/client/User.h"
#include <vector>
using namespace std;

namespace TPTP
{
	namespace Client
	{
		class Agent;
		class IProcess;

		class ACCommandHandler: public ICommandHandler
		{
			private:
				int responseReceived;
				int agentID;
				CommandElement* responseCommand;
				Semaphore_t responseReceivedSem;
			public:
				ACCommandHandler();
				virtual ~ACCommandHandler();
				void incomingCommand(INode* node, class CommandElement* command);
				int checkResponseReceived();
				CommandElement* getResponseCommand();
				int getAgentID();
				Semaphore_t* getResponseReceivedSem();				
		};

		class TPTP_CLASS_EXPORT AgentController
		{
			private:
				INode* _node;
				IConnection* _connection;
				int _consoleDataConnID;
				IDataProcessor* _consoleDataProcessor;
				void addGenericListener();
				
			public:
				AgentController();
				AgentController(class INode* node);
				~AgentController();
				//char*[] getAgentList();


				/**
				 * Retrieve the connection associated with this node object
				 */
				IConnection* getConnection();


				void setConnection(IConnection* conn);

				/*
				 * Authenticate the User Credentials with AC
				 *
				 */
				int authenticateUser(User* user);


				void disconnect();


				/* TPTP CLIENT API
				 * Clients should call this method to get the Agent Metadata XML string
				 * Takes the agent name as parameter.
				 */
				char* getAgentMetaData(char* agentName);

				/* TPTP CLIENT API
				 * Clients should call this method to get the list of running agents
				 * returns the array of agent names
				 */
				std::vector<Agent*>* queryRunningAgents(int processID, char* interfaceName);

				/* TPTP CLIENT API
				 * Clients should call this method to get the list of deployed agents
				 * returns the array of agent names
				 */
				std::vector<char*>* queryDeployedAgents(char* interfaceName);


				/* TPTP CLIENT API
				 * Clients should call this method to get the agentID
				 * Takes the agent name as parameter.
				 * Flags can be a combination (only if it makes sense) of the following values.
				 * TPTP_CONTROLLER_ACCESS - Request Control Access on the Agent
				 * TPTP_OBSERVER_ACCESS - Request Observer Access on the Agent
				 * TPTP_CREATE_INSTANCE - Creates a new instance even if an existing instance is available
				 * TPTP_RUNNING_AGENTS_ONLY - Request only the running agents
				 * TPTP_LOCK_AGENT - Request exclusive usage and others can't share this agent
				 */
				int getAgent(Agent* agent, int flags);


				/* 
				 * TPTP CLIENT API
				 * Get the Agent By the Process ID
				 * Flags can be a combination (only if it makes sense) of the following values.
				 * TPTP_CONTROLLER_ACCESS - Request Control Access on the Agent
				 * TPTP_OBSERVER_ACCESS - Request Observer Access on the Agent
				 * TPTP_LOCK_AGENT - Request exclusive usage and others can't share this agent
				 */
				int getAgentByProcessID(Agent* agent, int pid, int flags);

				/* 
				 * TPTP CLIENT API
				 * Get the Agent By the Agent Token passed by the Agent Controller previously
				 * Flags can be a combination (only if it makes sense) of the following values.
				 * TPTP_CONTROLLER_ACCESS - Request Control Access on the Agent
				 * TPTP_OBSERVER_ACCESS - Request Observer Access on the Agent
				 * TPTP_LOCK_AGENT - Request exclusive usage and others can't share this agent
				 */
				int getAgentByToken(Agent* agent, int token, int flags);

				/* 
				 * TPTP CLIENT API
				 * Get the Agent By the Agent ID
				 * Flags can be a combination (only if it makes sense) of the following values.
				 * TPTP_CONTROLLER_ACCESS - Request Control Access on the Agent
				 * TPTP_OBSERVER_ACCESS - Request Observer Access on the Agent
				 * TPTP_LOCK_AGENT - Request exclusive usage and others can't share this agent
				 */
				int getAgentByID(Agent* agent, int agentID, int flags);



				/* TPTP CLIENT API
				 * Sends the command to the specified destination(second parameter).
				 * The third parameter is the command handler where a response command (to
				 * the command being) sent will be forwarded to.
				 */
				void sendCommand(char* cmd, int destID, ICommandHandler* handler);


				void sendCommand(TPTPCommand* tptpCmd, ICommandHandler* handler);

				/* 
				 * Creates a data connection between the Client application and Agent Controller 
				 * Returns the data connection id received from AC
				 */
				int createDataConnection(int direction);

				/*
				 * Destroy Data Connection
				 */
				int destroyDataConnection(int dataConnID);

				/*
				 * Creates the Console Data Connection and returns the connectionid
				 */
				int getConsoleDataConnection();

				/*
				 * Get the Console Data Processor
				 */
				IDataProcessor* getConsoleDataProcessor();


				/* 
				 * Adds the data listener object for listening to any data
				 */
				int addDataListener(int dataConnID, IDataProcessor* dataProcessor);

				/* 
				 * Removess the Data Processor object (passed as parameter) listener				 
				 */
				int removeDataListener(int dataConnID, IDataProcessor* dataProcessor);



				int sendData(int dataConnectionID, char buffer[], int bufferLength);


				int sendConsoleData(char buffer[], int bufferLength);


				/* Add a listener object to listen to any events that belong to the interface specified
				 * returns the listenerid that can be used to remove the listener later				 
				 */
				long addEventListener(char* interfaceid,  ICommandHandler* listener);

				void removeEventListener(char* interfaceid, long listenerid);


				/* TPTP CLIENT API
				 * Creates a new Process instance.
				 */
				IProcess* createNewProcess();

				void deleteProcess(IProcess* process);

				void destroy();
				static std::vector<Agent *> agentList;				
		};

	}
}

#endif


