/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation, IBM.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial API and Implementation (Based on the Java
 *                                API implementation by IBM)
 *
 * $Id: Collector.h,v 1.6 2005/08/19 17:22:43 vnaikawadi Exp $
 *
 *******************************************************************************/ 



#ifndef  Collector_H
#define  Collector_H


#include "tptp/client/Agent.h"

namespace TPTP
{
	namespace Client
	{

		class CollectorCommandHandler: public AgentCommandHandler
		{
			public:
				virtual void incomingCommand(INode* node, CommandElement* command);
				CollectorCommandHandler(){};
				virtual ~CollectorCommandHandler(){};
		};


		class TPTP_CLASS_EXPORT Collector : public Agent
		{
			private:
				

			public:
				Collector();
				Collector(char* name);
				Collector(int id, char* name);
				~Collector();

				/* TPTP CLIENT API 
				 * All of the following commands are available as external API
				 * They perform the standard operation on the Collector
				 * Internally they build XML commands to perform the corresponding
				 * action and send the command to the collector running on the target 
				 * machine. Currently in this prototype only run and stop are implemented
				 */
				virtual void run();
				virtual void stop();
				virtual void cancel();
				virtual void pause();
				virtual void resume();

		};

	}

}



#endif


