/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM,Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Guru Nagarajan, Intel - initial API and implementation
 *    IBM - Initial Java API and implementation
 *
 * $Id: CommandElement.h,v 1.5 2006/02/10 19:54:15 vnaikawadi Exp $
 *
 *******************************************************************************/ 


#ifndef COMMANDELEMENT_H
#define COMMANDELEMENT_H

#include "tptp/TPTPExport.h"
#include <iostream>



class TPTP_CLASS_EXPORT CommandElement
{
	public:
		CommandElement();
		virtual ~CommandElement();


		unsigned long getContext();
		unsigned long getTag();
		unsigned long getDestination();
		unsigned long getSource();
		char* getCommandName();
		char* getCommand();

		void setSource(unsigned long source);
		void setContext(unsigned long context);
		void setDestination(unsigned long dest);
		void setCommandName(char *commandName);
		void setCommand(char* command);

		//pure virtual functions
		virtual void buildCommand()=0;	
		virtual unsigned int getSize()=0;
		virtual unsigned char* writeToBuffer(unsigned char* buffer,unsigned int offset)=0;
		virtual unsigned char* readFromBuffer(unsigned char* buffer,unsigned int offset)=0;
		
	protected:
		unsigned long _tag;
		unsigned long _context;
		unsigned long _dest;
		unsigned long _src;
		char* _commandName;
		char* _command;
};



#endif


