/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM,Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Guru Nagarajan, Intel - initial API and implementation
 *    IBM - Initial Java API and implementation
 *
 * $Id: CommandFragment.h,v 1.7 2008/11/25 20:51:52 jkubasta Exp $
 *
 *******************************************************************************/ 

 
#ifndef COMMANDFRAGMENT_H
#define COMMANDFRAGMENT_H

#include "tptp/TPTPExport.h"
#include "tptp/client/CommandElement.h"
#include "tptp/client/TPTP_String.h"

#include <iostream>
#include <vector>


class  TPTP_CLASS_EXPORT CommandFragment: public CommandElement
{
	public:
		CommandFragment();
		virtual ~CommandFragment();

		void setCommand(std::string command);
		void setCommandPart(char* command);
		std::string getCommandData();

		virtual void buildCommand();
		virtual unsigned int getSize();
		virtual unsigned char* readFromBuffer(unsigned char *buffer,unsigned int offset);
		virtual unsigned char* writeToBuffer(unsigned char *buffer,unsigned int offset);

		static std::vector<std::string> getXMLFromBuf(std::string input);
		
	protected:
		TPTP_String _commandData;
		char* _commandPart;
};


#endif
	
#define CMD_OPEN_TAG "<Cmd>"
#define CMD_CLOSE_TAG "</Cmd>"
