/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial API and Implementation
 *
 * $Id: ConnectionInfo.h,v 1.1 2005/08/20 19:29:15 vnaikawadi Exp $
 *
 *******************************************************************************/ 


#ifndef  ConnectionInfo_H
#define  ConnectionInfo_H

#include "tptp/TPTPExport.h"

enum CommProtocol { PROTO_SOCKET, PROTO_HTTP, PROTO_HTTPS};

namespace TPTP
{
	namespace Client
	{
		class TPTP_CLASS_EXPORT ConnectionInfo 
		{

			private:
				char* _hostName;
				int _portNum;
				CommProtocol _protocol;

			
			public:
				/**
				 * Create ConnectionInfo object with the host name
				 * and port number.
				 */
				ConnectionInfo(char* hostName, int portNum); 
				
				
				/**
				 * Retrieve the host name 
				 */
				char* getHostName();

				/**
				 * Set the host name
				 */
				void setHostName(char* hostName);
				
				
				/**
				 * Retrieve the port number
				 */
				int getPortNum();
				

				/**
				 * Set the Port number
				 */
				void setPortNum(int portNum);

				/**
				 * Retrieve the port number
				 */
				enum CommProtocol getProtocol();
				

				/**
				 * Set the Port number
				 */
				void setProtocol(enum CommProtocol protocol);
		};
	}
}

#endif
