/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM,Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Guru Nagarajan, Intel - initial API and implementation
 *    IBM - Initial Java API and implementation
 *
 * $Id: Constants.h,v 1.7 2006/03/03 23:26:12 vnaikawadi Exp $
 *
 *******************************************************************************/ 


#ifndef CONSTANTS_H
#define CONSTANTS_H


#include "tptp/TPTPExport.h"

class TPTP_CLASS_EXPORT Constants 
{

	/* Various Message types currently available */
	public:
		static  const unsigned char RA_ACKNOWLEDGEMENT_MESSAGE		;
		static  const unsigned char RA_CONTROL_MESSAGE				;
		static  const unsigned long RA_MAGIC						;
		static  const unsigned long RA_VERSION						;
		static  const unsigned long RA_AUTHENTICATE					;
		static  const unsigned long RA_LAUNCH_PROCESS				;
		static  const unsigned long RA_KILL_PROCESS					;
		static  const unsigned long RA_QUERY_PROCESS_LIST			;
		static  const unsigned long RA_QUERY_AGENT_LIST				;
		static  const unsigned long RA_QUERY_AGENT_DETAILS			;
		static  const unsigned long RA_REGISTER_AGENT_NOTIFICATION	;
		static  const unsigned long RA_ATTACH_TO_AGENT				;
		static  const unsigned long RA_DETACH_FROM_AGENT			;
		static  const unsigned long RA_START_MONITORING_AGENT_REMOTE;
		static  const unsigned long RA_START_MONITORING_AGENT_LOCAL	;
		static  const unsigned long RA_STOP_MONITORING_AGENT		;
		static  const unsigned long RA_SET_NAME_VALUE_PAIR			;
		static  const unsigned long RA_GET_PROPERTY_LIST			;
		static  const unsigned long RA_MANAGE_FILE					;


		/* The extension point for custom protocol piggy-backing */
		static  const unsigned long RA_CUSTOM_COMMAND	;
		static  const unsigned long RA_BINARY_CUSTOM_COMMAND;

		/* The various COMMAND_ID's from the Remoteable Agent Controller (client targeted flows) */
		static  const unsigned long RA_AUTHENTICATION_FAILED;
		static  const unsigned long RA_AUTHENTICATION_SUCCESSFUL;
		static  const unsigned long RA_SERVER_SECURITY_REQUIREMENTS;
		static  const unsigned long RA_PROCESS_LAUNCHED			;
		static  const unsigned long RA_PROCESS_EXITED				;
		static  const unsigned long RA_PROCESS_LIST				;
		static  const unsigned long RA_AGENT_LIST					;
		static  const unsigned long RA_AGENT_ACTIVE				;
		static  const unsigned long RA_AGENT_INACTIVE	;
		static  const unsigned long RA_AGENT_DETAILS	;
		static  const unsigned long RA_ERROR_STRING	;
		static  const unsigned long RA_CONTROLLER_REQUEST_MONITOR;
		static  const unsigned long RA_PROPERTY_LIST			;

		static  const unsigned long RA_AGENT_QUERY_STATE		; // Bug 54376
		static  const unsigned long RA_AGENT_ATTACHED			; // Bug 54376
		static  const unsigned long RA_AGENT_DETACHED			; // Bug 54376

		static  const unsigned long RA_RESOURCE_LOCATION		;


		static  const unsigned long RA_GET_AGENT				;
		static  const unsigned long RA_AGENT_ID				;

		/**
		* Various constants that both the client and server must adhere to.
		*/
		static  const unsigned int CTL_PORT_NUM_SERVER		; /* hardcoded to start with */
		static  const unsigned int CTL_PORT_NUM_CLIENT		; /* hardcoded to start with */
		static  const unsigned int MESSAGE_HEADER_LENGTH		;		/* 10 byte header to start with */
		static  const unsigned int MAX_MESSAGE_LENGTH			;	/* The maximum size of a message */
		static  const unsigned int MAX_COMMAND_LINE_LENGTH	;	/* Maximum length of a command line string */
		static  const unsigned int DATA_PORT_NUM_CLIENT		;
		static  const unsigned int MAX_DATA_LENGTH			;	/* The size of the data buffer for sockets */

		/* This package is ported from C, so to facilitate sizeof code for primitives
		the following constants are provided */

		static  const unsigned int sizeofByte					;
		static  const unsigned int sizeofChar					;
		static  const unsigned int sizeofShort					;
		static  const unsigned int	sizeofLong					;
		static  const unsigned int OLD_RAC_MESSAGE				;
		static  const unsigned int NEW_AC_MESSAGE				;
		static  const unsigned int NEW_AC_DEFAULT_MESSAGE		;

		static  const unsigned long  AC_MAGIC_NUMBER			;

		//static  const unsigned long  DATA_PATH_SEND    ;
		//static  const unsigned long	 DATA_PATH_RECEIVE ;
		//static  const unsigned long	 DATA_PATH_TWOWAY;
		static const int DATA_MESSAGE_HEADER_LENGTH;
};


#endif


