/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM,Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Guru Nagarajan, Intel - initial API and implementation
 *    IBM - Initial Java API and implementation
 *
 * $Id: ControlMessage.h,v 1.5 2006/02/10 19:54:15 vnaikawadi Exp $
 *
 *******************************************************************************/ 

#ifndef CONTROLMESSAGE_H
#define CONTROLMESSAGE_H

#include "tptp/TPTPExport.h"
#include "tptp/client/Message.h"
#include "tptp/client/CommandElement.h"
#include "tptp/client/TPTP_String.h"
#include <vector>


class TPTP_CLASS_EXPORT ControlMessage: public Message
{
	public:
			ControlMessage();
			~ControlMessage();
			
			unsigned long _length;
			std::vector<CommandElement*> _entries;
			
			CommandElement* getCommand(int offset);
			void appendCommand(CommandElement *command);
		
			unsigned int getCommandCount();
			unsigned long getLength();
			unsigned int getSize();

			unsigned char* readFromBuffer(unsigned char *buffer,unsigned int offset);
			unsigned char* writeToBuffer(unsigned char *buffer,unsigned int offset);
			
			TPTP_String getKey();
			void setKey(TPTP_String key);

	protected:
			TPTP_String _key;

};

#endif




