/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial API and Implementation
 *
 * $Id: EnvVariable.h,v 1.1 2005/08/20 19:27:13 vnaikawadi Exp $
 *
 *******************************************************************************/ 


#ifndef  Variable_H
#define  Variable_H

#include "tptp/TPTPExport.h"

namespace TPTP
{
	namespace Client
	{
		class TPTP_CLASS_EXPORT EnvVariable 
		{

			private:
				char* _name;
				char* _value;
			
			public:
				/**
				 * Create an environment variable with the specified name
				 * value pair.
				 */
				EnvVariable(char* name, char* value); 
				
				
				/**
				 * Retrieve the name of this environment variable.
				 */
				char* getName();

				/**
				 * Set the name of this environment variable.
				 */
				void setName(char* name);
				
				
				/**
				 * Retrieve the value of this environment variable.
				 */
				char* getValue();
				

				/**
				 * Retrieve the value of this environment variable.
				 */
				void setValue(char* value);
		};
	}
}

#endif
