/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial API and Implementation
 *
 * $Id: FileDataProcessor.h,v 1.5 2005/07/29 22:22:31 vnaikawadi Exp $
 *
 *******************************************************************************/ 


#ifndef  FileDataProcessor_H
#define  FileDataProcessor_H


#include "IDataProcessor.h"
#include "tptp/TPTPCommon.h"
#include "tptp/TPTPTypes.h"
#include "tptp/TPTPUtils.h"

#include <stdio.h>


using namespace TPTP::Client;

typedef struct {
	char* name;
	FILE* fp;
	Semaphore_t *semaphore;
} tptp_file_t;

class FileDataProcessor: public IDataProcessor
{
	private:
		FILE* fileFp;
		tptp_list_t fileOpList;
		Lock_t fileOpListLock;
		tptp_int32 findFileRecordByName(const char *fileName, tptp_file_t *fileRec);
	public:
		FileDataProcessor();
		~FileDataProcessor();
		/**
		 * Handle the data coming 
		 */
		virtual void incomingData(char buffer[], tptp_int32 length, DIME_HEADER_PTR_T dimeHeader);
		/**
		 * Invalid Data Type
		 */
		virtual void invalidDataType(char data[], tptp_int32 length);
		/**
		 * Waiting for data
		 */
		virtual void waitingForData();		

		void initializeFileTransfer(char *fileName, FILE *fp);

		void waitForFileComplete(char *fileName);

};



#endif


