/*******************************************************************************
 * Copyright (c) 2005, 2006 Intel Corporation, IBM.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Kevin P O'Leary, Intel - Initial API and Implementation (Based on the Java
 *                                API implementation by IBM)
 *
 * $Id: FileTransfer.h,v 1.4 2006/02/10 19:54:15 vnaikawadi Exp $
 *******************************************************************************/ 



#ifndef  FileTransfer_H
#define  FileTransfer_H


#include "Collector.h"
#include "FileDataProcessor.h"
#include "ICommandHandler.h"
#include "tptp/TPTPUtils.h"

namespace TPTP
{
	namespace Client
	{
		class TPTP_CLASS_EXPORT FileTransfer : public Collector
		{
			private:
				tptp_int32 debugOn;
				/* Data Path only needs to be established once! */
				tptp_int32 dataInit;

				tptp_int32 dataConnectionId;    

				FileDataProcessor *dataProcessor;  
				void startFileDataProcessor();

				tptp_int32 sendFileData(char *buffer, tptp_int32 bufferLength, 
						tptp_int32 recType, char *fileName);
			public:
				FileTransfer();
				FileTransfer(char* name);
				FileTransfer(tptp_int32 id, char* name);
				~FileTransfer();

				/* TPTP CLIENT API 
				 */
				tptp_int32 getFile(char *localFile, char *remoteFile);
				tptp_int32 putFile(char *localFile, char *remoteFile);
				tptp_int32 deleteFile(char *remoteFile);

		};

	}

}



#endif


