/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation, IBM.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial API and Implementation (Based on the Java
 *                                API implementation by IBM)
 *
 * $Id: ICommandHandler.h,v 1.2 2005/06/28 02:21:19 vnaikawadi Exp $
 *
 *******************************************************************************/ 


#ifndef  ICommandHandler_H
#define  ICommandHandler_H

#include "tptp/TPTPExport.h"
#include "tptp/client/CommandElement.h"


namespace TPTP
{
	namespace Client
	{
		class TPTP_CLASS_EXPORT ICommandHandler 
		{
			public:
				/* TPTP CLIENT API
				 * This is a pure virtual function. There is no implementation
				 * The client implementation should code classes that extend from
				 * ICommandHandler and provide implementation for this method.
				 * The communication in TPTP framework is asynchronous in nature.
				 * In the sense, when a command is sent to AC or Agent, the response
				 * to this is sent as another command to Client application.
				 * To get responses to any custom commands to agents, the client application should 
				 * provide handler classes and register them as handler while sending a
				 * command. The AgentControllerProxy class has a method 
				 * void sendCommand(char* cmd, int destID, ICommandHandler* handler).
				 * Should pass the handler instance as the third parameter and the
				 * following method will be called when a response is received */
				virtual void incomingCommand(class INode* node, class CommandElement* command)=0;

		};

	}

}


#endif


