/*******************************************************************************
 * Copyright (c) 2005, 2006 Intel Corporation, IBM.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial API and Implementation (Based on the Java
 *                                API implementation by IBM)
 *
 * $Id: IConnection.h,v 1.8 2006/02/10 19:54:15 vnaikawadi Exp $
 *
 *******************************************************************************/



#ifndef  IConnection_H
#define  IConnection_H

#include "tptp/TPTPExport.h"
#include "tptp/client/ICommandHandler.h"
#include "tptp/client/IDataProcessor.h"
#include "tptp/client/ControlMessage.h"
#include "tptp/TPTPCommand.h"
#include "tptp/client/ConnectionInfo.h"


namespace TPTP
{
	namespace Client
	{

		class TPTP_CLASS_EXPORT IConnection
		{
			public:

				/* Though the following API is available externally
				 * the client applications will not have a need to use this API
				 * Wrappers for most of this API is provided by AgentControllerProxy */

				virtual void sendMessage(ControlMessage* msg, ICommandHandler* handler)=0;

				virtual void sendMessage(TPTPCommand* msg, ICommandHandler* handler)=0;

				virtual void disconnect()=0;

				virtual class INode* getNode()=0;

				virtual bool isActive()=0;

				virtual int getPort()=0;

				virtual int connect(class INode* node, int port)=0;

				virtual int connect(class INode* node, ConnectionInfo* connInfo)=0;

				virtual int getConnectionId()=0;

				virtual long getNextContextID()=0;

				virtual int createDataConnection(int direction, int commandflags) =0;

				/*
				 * Destroy Data Connection
				 */
				virtual int destroyDataConnection(int dataConnID)=0;

				virtual int addDataListener(int dataConnectionID, IDataProcessor* dataProcessor)=0;

				virtual int removeDataListener(int dataConnectionID, IDataProcessor* dataProcessor)=0;

				virtual int sendData(int dataConnectionID, char buffer[], int bufferLength)=0;

		};

	}

}
#endif

