/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation, IBM.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial API and Implementation (Based on the Java
 *                                API implementation by IBM)
 *
 * $Id: IDataProcessor.h,v 1.2 2005/06/28 02:21:19 vnaikawadi Exp $
 *
 *******************************************************************************/ 




#ifndef  IDataProcessor_H
#define  IDataProcessor_H

#include "tptp/TPTPExport.h"
#include "tptp/dime.h"

namespace TPTP
{
	namespace Client
	{
		class TPTP_CLASS_EXPORT IDataProcessor 
		{

			public:
				/** TPTP CLIENT API
				 * Client applications need to extend from IDataProcessor class
				 * and provide implementation for the methods in this class.
				 * The Data Processor is the object that is called whenever there
				 * is data available from the data connection with which this processor
				 * has been registered as listener while creating a data connection.
				 * This method is called only when data is received over the data
				 * connection
				 * Arg1 - Data Buffer (contains the data received)
				 * Arg2 - Lengthe of the data received
				 * Arg3 - Not used currently (most probably will be removed)
				 * 
				 * The client application should provide implementation to 
				 * handle or process the data coming
				 */
				virtual void incomingData(char buffer[], int length, DIME_HEADER_PTR_T dimeHeader)=0;
				/**
				 * TPTP CLIENT API - Called when the data recieved is invalid
				 * NOTE: currently not implemented in the prototype.
				 * Invalid Data Type
				 */
				virtual void invalidDataType(char data[], int length)=0;
				/**
				 * TPTP CLIENT API
				 * Called when there is no data available
				 * NOTE: Not implemented in the prototype
				 * Waiting for data
				 */
				virtual void waitingForData()=0;

		};

	}

}


#endif



