/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation, IBM.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial API and Implementation (Based on the Java
 *                                API implementation by IBM)
 *
 * $Id: INode.h,v 1.5 2005/08/20 19:29:15 vnaikawadi Exp $
 *
 *******************************************************************************/



#ifndef  INode_H
#define  INode_H

#include "tptp/TPTPExport.h"

#include "tptp/client/IConnection.h"
#include "tptp/client/AgentController.h"
#include "tptp/client/User.h"
#include "tptp/client/ConnectionInfo.h"


namespace TPTP
{
	namespace Client
	{
		class AgentController;

		class TPTP_CLASS_EXPORT INode
		{
			public:

			/**
			 * TPTP CLIENT API
			 * Connects to the taget machine represented by this Node at the
			 * port specified. Returns connection object
			 * Arg1 - Port number 
			 */
			virtual AgentController* connect(int port)=0;

			/**
			 * TPTP CLIENT API
			 * Connects to the taget machine represented by this Node at the
			 * port specified. Returns connection object
			 * Arg1 - Connection Information (pointer to ConnectionInfo instance) 
			 */
			virtual AgentController* connect(ConnectionInfo* connInfo)=0;

			/*
			 * Connection to AC and authenticate the user 
			 */
			virtual AgentController* connect(ConnectionInfo* connInfo, User* user)=0;

			/**
			 * disconnect from the node at the specified port.
			 */
			void disconnect(int port);

			/* TPTP CLIENT API
			 * Returns the representative instace of the AgentController running
			 * on the target machine. The returned proxy instance should be used
			 * for communicating with the AC.
			 * 
			 */
			virtual AgentController* getAC(int port)=0;

			/**
			 * TPTP CLIENT API
			 * Retrieve the connection associated with this node object
			 */
			//virtual IConnection* getConnection()=0;


			/**
			 * TPTP CLIENT API
			 * Retrieve the InetAddress for this Node.
			 */
			virtual char* getInetAddress()=0;


			/**
			 * TPTP CLIENT API
			 * Retrieve the host name for this Node.
			 */
			virtual char* getName()=0;

		   /**
		     * TPTP CLIENT API
			 * Returns if the node is connected to the AC on the target machine
			 */
			//virtual bool isConnected(int port)=0;


		};

	}

}

#endif



