/*******************************************************************************
 * Copyright (c) 2005, 2006 Intel Corporation, IBM.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial API and Implementation (Based on the Java
 *                                API implementation by IBM)
 *
 * $Id: IProcess.h,v 1.6 2006/02/10 19:54:15 vnaikawadi Exp $
 *
 *******************************************************************************/



#ifndef  IProcess_H
#define  IProcess_H

#include "tptp/TPTPExport.h"
#include "tptp/client/EnvVariable.h"
#include "tptp/client/INode.h"
#include "tptp/client/ProcessInfo.h"
#include "tptp/client/IConsole.h"


namespace TPTP
{
	namespace Client
	{
		

		class TPTP_CLASS_EXPORT IProcess
		{
			public:

			  /**

				* Launches the process on the node that was provided

				* to the ProcessFactory during construction of this

				* Process instance.  If the Process was already launched

				* the ProcessActiveException is thrown.

				*/

			   virtual void launch()=0;

           

			   /**

				* Kills this process if it is active.

				*/

			   virtual void kill()=0;

           
    

			   /**

				* Adds a ProcessListener to this Process instance.

				* @see ProcessListener

				*/

			   virtual void addEventListener(char* interfaceID, ICommandHandler* listener)=0;

           

			   /**

				* Removes a ProcessListener from this Process instance.

				* @see ProcessListener

				*/

			   virtual void removeEventListener(char* interfaceID, ICommandHandler* listener)=0;

           

			   /**

				* Retrieves the Node that this Process instance

				* is associated with.

				* @see Node

				*/

			   virtual INode* getNode()=0;

           

			   /**

				* Save a user friendly name so that it can be retrieved later via Process#getName()

				*/

			   virtual void setName(char* name)=0;

           

			   /**

				* Retrieves the name of this process as provided

				* by Process#setName()

				*/

			   virtual char* getName()=0;

           

			   /**

				* Retrieves the uuid of this process if it is known, null otherwise.

				*/

			   virtual char* getUUID()=0;            

           

			   /**

				* Set the exectauble name for this process.

				*/

			   virtual void setExecutable(char* exe)=0;

           

			   /**

				* Get the exectable name for this process.

				*/

			   virtual char* getExecutable()=0;

           

			   /**

				* Retrieve the process ID (pid) for this process

				*/

			   virtual char* getProcessId()=0;

           
			   /**
				* Set the Process Id
				*/
			   virtual void setProcessId(char* processId)=0;
           

			   /**

				* Check if the Process is Active

				*/

			   virtual bool isActive()=0;

           

			   /**
				* Retrieves the console of this Process instance.
				*/
			   virtual IConsole* getConsole()=0;

           

			   /**

				* Set an environment variable to this process.

				*/

			   virtual void setEnvironmentVariable(char* name, char* value)=0;

           

			   /**

				* Prepends an environment variable to this process.

				*/

			   //virtual void prependEnvironmentVariable(char* name, char* value)=0;

           

			   /**

				* Apppends an environment variable to this process.

				*/

			   //virtual void appendEnvironmentVariable(char* name, char* value)=0;

           

			   /**

				* Retrieves an environment variable from this process.

				* @return the environment variable with the specified name attribute if it exists, null otherwise.

				*/

			   virtual char* getEnvironmentVariable(char* name)=0;

           

			   /**

				* Removes an environment variable from this process.

				*/

			   virtual void removeEnvironmentVariable(char* name)=0;

           

			   /**

				* Provides an enumeration of each Variabe comprising

				* the entire environment of this process.

				* @see Variable

				*/

			   //virtual Enumeration getEnvironment()=0;

			   /**

				* Prepend the parameters for this process

				*/

			   //virtual void prependParameter(char* parameter)=0;

			   /**

				* Append the parameters for this process

				*/

			   //virtual void appendParameter(char* parameter)=0;

			   /**

				* Set the parameter for this process

				*/

			   virtual void setParameter(char* parameter)=0;

           

			   /**

				* Retrieves the parameters of the process.

				*/

			   virtual char* getParameter()=0;

           

			   /**

				* Set's the home directory of the process.

				*/

			   virtual void setLocation(char* location)=0;

           

			   /**

				* Get the Process Launch Info

				*/

			   virtual ProcessInfo* getProcessInfo()=0;

           

			   /**

				* Set the Process Launch Info

				*/

			   virtual void setProcessInfo(ProcessInfo* pInfo)=0;


			   /**

				* Set the Process Launch Info

				*/

			   virtual void setSource(int clientSrcID)=0;
			   


		};

	}

}

#endif

