/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM,Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Guru Nagarajan, Intel - initial API and implementation
 *
 *    IBM - Initial Java API and implementation
 *
 * $Id: Message.h,v 1.3 2006/02/10 19:54:15 vnaikawadi Exp $
 *******************************************************************************/ 


#ifndef MESSAGE_H
#define MESSAGE_H

#include "tptp/TPTPExport.h"
#include <iostream>
#include <string> 




class TPTP_CLASS_EXPORT Message
{

	public:
	//The following const defs should be protected or private - ease of coding for the prototype
	// hence public
		/* Magic Number */
		unsigned long _magicNumber;
		/* The protocol version number */
		unsigned long _version;

		/* Length of the message */
		unsigned long _type;

		/* The ticket number of the message */
		unsigned long _ticket;

		/* For New AC Message - Flags */
		unsigned long _flags;

		/* Message Type */
		unsigned long _messageType;//Old RAC Format- OLD_RAC_MESSAGE(1), New RAC Format - NEW_AC_MESSAGE(2)

		/* MD5 Flag */
		char* _md5Flag;

		Message();
		~Message();
		unsigned int getSize();
		unsigned long getTicket();
		unsigned long getType();
		unsigned long getVersion();
		unsigned long getMessageType();
		unsigned long getFlags();
		void setMagicNumber(unsigned long magicNumber);
		void setTicket(unsigned long ticket);
		void setVersion(unsigned long version);
		void setMessageType(unsigned int type);
		void setFlags(unsigned long flags);
		
		// Buffer - RW from/to 
		//Need to test this 4/1/04

		unsigned char* readFromBuffer(unsigned char* buffer,unsigned int offset);
		unsigned char* writeToBuffer(unsigned char* buffer,unsigned int offset);

		static unsigned char* readTPTPUINTFromBuffer(unsigned char *buffer, unsigned int* uint);
		static unsigned char* copyTPTPUINTToBuffer(unsigned	char *buffer, unsigned int length); 
		
		static unsigned char* copyTPTPSTRINGToBuffer(unsigned char *buffer, std::string stringData);
		static unsigned char* readTPTPSTRINGFromBuffer(unsigned char *buffer, std::string newString);

		static unsigned char* copyTPTPBinaryArrayToBuffer(unsigned char *buffer, std::string binaryData);
		static unsigned char* readTPTPBinaryArrayFromBuffer(unsigned char *buffer,std::string newArray);

		//TO DO 
		static unsigned char* writeTPTPInetAddressToBuffer();
		static unsigned char* readTPTPInetAddressToBuffer();

		/*  
		static int readFromBuffer(char* buffer, int offset);
		static int readRAStringFromBuffer(char[] buffer, int offset, RAString rastring);
		static int readRABinaryArrayFromBuffer(char[] buffer, int offset, RABinaryArray raarray);
		static int readRAInetAddressFromBuffer(char[] buffer, int offset, RAInetAddress ipaddr);
		
		static int writeRALongToBuffer(char[] buffer, int offset, long ralong);
		static int writeRAStringToBuffer(char[] buffer, int offset, RAString rastring);
		static int writeRABinaryArrayToBuffer(char[] buffer, int offset, RABinaryArray raarray);
		static int writeRAInetAddressToBuffer(char[] buffer, int offset, RAInetAddress addr);
		int writeToBuffer(char[] buffer, int offset);
		*/
};


#endif


