/*******************************************************************************
 * Copyright (c) 2005, 2006 Intel Corporation, IBM.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial API and Implementation (Based on the Java
 *                                API implementation by IBM)
 *
 * $Id: NodeFactory.h,v 1.4 2006/02/10 19:54:15 vnaikawadi Exp $
 *
 *******************************************************************************/



#ifndef  NodeFactory_H
#define  NodeFactory_H

#include "tptp/TPTPExport.h"
#include "tptp/client/INode.h"

//#include <vector>
#include <map>



namespace TPTP
{
	namespace Client
	{

		typedef std::map<char*, INode*> NodeList ;

		class TPTP_CLASS_EXPORT NodeFactory
		{
			private:				
				static NodeList _servers;

			public:

				/* 
				 * TPTP CLIENT API
				 * This is the static method of NodeFactory class
				 * The createNode method creates a Node and returns it
				 * More overloaded methods will be provided later that take
				 * different combinations of host name, ip address etc.
				 *
				 * Internally maintains the list of nodes created for book
				 * keeping and avoiding duplication. This is not implemented in the
				 * prototype (TODO)
				 */
				static INode* createNode(char* hostName);

				/* 
				 * TPTP CLIENT API
				 * This is the static method of NodeFactory class
				 * The deleteNode method destroys a Node with the specific host name 
				 */
				static void deleteNode(INode* node);

		};

	}

}

#endif

