/*******************************************************************************
 * Copyright (c) 2005, 2006 Intel Corporation, IBM.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial API and Implementation 
 *
 * $Id: ProcessInfo.h,v 1.4 2006/02/10 19:54:15 vnaikawadi Exp $
 *
 *******************************************************************************/




#ifndef  ProcessInfo_H
#define  ProcessInfo_H


#include "tptp/client/EnvVariable.h"


#include <map>

using namespace std;

namespace TPTP
{

	namespace Client
	{

		class ProcessInfo
		{
			private:
				/** 
				 * Process Name
				 */
				char* _processName;
				
				/**
				 * Executable Path 
				 */
				char* _executable;
				
				/**
				 * Environment Variable Collection
				 */
				 EnvVariable* _environment;
				 std::map<char*, char*> _envMap;
				
				/**
				 * Parameters or arguments list
				 */
				char* _parameters;
				
				/**
				 * Working Directory from where process will be launched
				 */
				char* _workingDir;


			public:

				/**
				 *  Constructor 
				 */
				ProcessInfo();


				/**
				 *  Destructor 
				 */
				~ProcessInfo();				

				
				/**
				 *  Set the Process Name 
				 */
				void setProcessName(char* name);
				
				/** 
				 * get the Process Name 
				 */
				char* getProcessName();
				
				/** 
				 * Get the Executable name/path 
				 */
				char* getExecutable();
				
				/** 
				 * Set the Executable name/path 
				 */
				void setExecutable(char* executable);
				
				/** 
				 * Add an environment variable to the process launch config 
				 */
				void addEnvironmentVariable(char* name, char* value);
				
				/** 
				 * Return the Environment variable name and value 
				 */
				char* getEnvironmentVariable(char* name);
				
				/** 
				 * Remove the environment variable
				 */
				void removeEnvironmentVariable(char* name);
				
				/** 
				 * Get the process launch environment 
				 */
				//Hashtable getEnvironment();
				
				/** 
				 * Set the parameters/arguments 
				 */
				void setParameters(char* parameters);
				
				/** 
				 * Get the parameters/arguments 
				 */
				char* getParameters();
				
				/** 
				 * Set the working directory for launching the process 
				 */
				void setWorkingDirectory(char* location);
				
				/** 
				 * get the working directory for launching the process 
				 */
				char* getWorkingDirectory();
		};

	}

}



#endif

