/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM,Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Guru Nagarajan, Intel - initial API and implementation
 *    IBM - Initial Java API and implementation
 *
 * $Id: TPTP_String.h,v 1.4 2006/09/12 21:46:14 akaylor Exp $
 *
 *******************************************************************************/ 


#ifndef TPTP_STRING
#define TPTP_STRING

#include "tptp/TPTPExport.h"
#include <string>
#include <iostream>



class TPTP_CLASS_EXPORT TPTP_String
{
	public:
		TPTP_String(std::string data);
		TPTP_String();
		~TPTP_String();
		long	length();
		
		void	setData(std::string data);
		std::string	getData();

		int		getSize();
		int		getPadding();
		
		int encodeUTF(char* inputcharset, char** str);
		int decodeUTF(char* inputcharset, char** str);

		/*
		** If String lib cannot be used then define a structure to do the string
		** TO DO if Required -- GN
		typedef struct 
		{
			unsigned int length;
			char *data;
		}tptp_string_t;
		*/
	private:
		int		_length;
		std::string	_data;
		int		_padding;
		void	calculatePadding();


};	


#endif


