/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Guru Nagarajan, Intel - initial API and implementation
 *
 * $Id: TPTP_XMLHandler.h,v 1.1 2005/06/01 17:41:01 vnaikawadi Exp $
 *
 *******************************************************************************/ 

#ifndef TPTP_XMLHANDLER_H
#define TPTP_XMLHANDLER_H

#include "tptp/TPTPExport.h"
#include <xercesc/sax/HandlerBase.hpp>
#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/util/TransService.hpp>
#include <xercesc/parsers/SAXParser.hpp>
#include <xercesc/framework/XMLFormatter.hpp>
//need this for the string input parsing
#include <xercesc/framework/MemBufInputSource.hpp>
#include <iostream>
#include <vector>
#include <map>
#include <string>



XERCES_CPP_NAMESPACE_USE


class TPTP_CLASS_EXPORT TPTP_XMLHandler : public HandlerBase
{
	public:
		TPTP_XMLHandler();
		~TPTP_XMLHandler();

		std::vector<std::string> agentVec;
		std::map<std::string,std::string>				elements;
		std::map<std::string,std::string>				attributes;
		std::map<std::string,std::string>::iterator		iter;
	   void endDocument();
	   void endElement(const XMLCh* const name);

	   void characters(const XMLCh* const chars,
						const unsigned int length);

	   void startDocument();

	   void startElement(const XMLCh* const name,
						  AttributeList& attributes);

	   void warning(const SAXParseException& exception);
	   void error(const SAXParseException& exception);
	   void fatalError(const SAXParseException& exception);

		/* Implementation of the SAX DTDHandler interface */
	   void notationDecl( const XMLCh* const name,
						  const XMLCh* const publicId,
						  const XMLCh* const systemId);

	   void unparsedEntityDecl(const XMLCh* const name,
								const XMLCh* const publicId,
								const XMLCh* const systemId,
								const XMLCh* const notationName);
   
	   static std::string getAgentID(const char *input);
    
};


#endif


