/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial API and Implementation
 *
 * $Id: User.h,v 1.1 2005/08/20 19:29:15 vnaikawadi Exp $
 *
 *******************************************************************************/ 


#ifndef  User_H
#define  User_H

#include "tptp/TPTPExport.h"

namespace TPTP
{
	namespace Client
	{
		class TPTP_CLASS_EXPORT User 
		{

			private:
				char* _username;
				char* _password;
				//bool _passwordEncrypted = FALSE;

			
			public:
				/**
				 * Create an environment variable with the specified name
				 * value pair.
				 */
				User(char* username, char* password); 
				
				
				/**
				 * Retrieve the name of this environment variable.
				 */
				char* getUserName();

				/**
				 * Set the name of this environment variable.
				 */
				void setUserName(char* name);
				
				
				/**
				 * Retrieve the value of this environment variable.
				 */
				char* getPassword();
				

				/**
				 * Retrieve the value of this environment variable.
				 */
				void setPassword(char* password);

				/**
				 * Retrieve the value of this environment variable.
				 */
				//void setPassword(char* password, EncryptService* encryptService);
		};
	}
}

#endif
