/**********************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RACTypes.h,v 1.14 2009/08/26 14:59:57 jwest Exp $
 *
 * Contributors:
 *    Andy Kaylor, Intel - Revised structures substaintially for 
 *                         agent compatibility TL implementation
 *    IBM - All structures initially based on RAServerTypes2.h
 *
 * $Id: RACTypes.h,v 1.14 2009/08/26 14:59:57 jwest Exp $
 *
 **********************************************************************/

#ifndef _RACTYPES_H_
#define _RACTYPES_H_

#include "tptp/compatibility/RAComm.h"

#ifdef MVS
	#include "tptp/system.h"
#endif

/* 215066 */
enum _clientMode {RA_DYNAMIC, RA_HEADLESS};
typedef enum _clientMode ra_clientMode_t;


/* These are the various types for maintaining the process list
   and associated agents within the server instance.  Essentially
   it is intended to objectify the data structures as much as possible.
*/
#ifdef __cplusplus
extern "C" {
#endif

/* Declarators */
struct _client_t;
struct _process_t;
struct _process_list_node;
struct _process_list;
struct _agent_list_node;
struct _agent_list;

/*
 * Agent
 */
typedef struct {
	BOOL attached;					/* Is a client attached to the agent */
	BOOL logging;					/* Is the agent currently logging */
	BOOL IPCBufCreated;				/* Has the IPC buffer/channel been created */
	ra_uint_t context;				/* Context ID this client is to be notified on when this agent is active */
	struct _client_t *client;		/* The client associated with this agent (if there is one) */
	struct _client_t *prev_client;	/* Previous client associated with this agent (if there is one) */ /* 9693 */
	RA_HANDLE   pipe;
	ra_string_t agentName;			/* The Agent name */
	ra_string_t agentUUID;			/* The UUID of the agent */
	ra_string_t agentType;			/* The agent type */
	ra_uint_t   IPCBufSize;			/* size of buffer/channel used to send data to server 198757 */
	struct _process_t  *process;	/* Back pointer to the process */
	struct _agent_list_node *node;	/* Back pointer to the agent list held by the process */
	ra_clientMode_t clientMode;		/* 215066 */
	ra_string_t logFile;			/* The Agent name */
	tptp_uint32 agentID;            /* AK -- added for compatibility support.  This is the ID by which the new agent controller knows our agent */
	tptp_uint32 agentToken;         /* AK -- added for compatibility support.  This is a token which we can use to get a reference to the agent */
	tptp_uint32 dataConnectionID;   /* KO -- added for compatibility support.  Used to identify data connection id */
	tptp_uint32 isProcessingData;   /* AK -- added for compatibility support.  This is a flag to indicate that data processing hasn't finished  */
	tptp_uint32 dataReceived;       /* AK -- added for compatibility support.  This is a flag to indicate that data processing hasn't finished  */
	Semaphore_t dataSemaphore;      /* AK -- added for compatibility support.  This semaphore is signaled when data processing is complete      */
} agent_t;							

typedef struct _agent_list_node {
	agent_t *agent;
	struct _agent_list_node *next;
	struct _agent_list_node *previous;
	struct _agent_list *list;
}agent_list_node_t;

typedef struct _agent_list {
	agent_list_node_t *head;
	agent_list_node_t *tail;
}agent_list_t;

/*
 * Client
 * AK - This structure is entirely replaced for compatibility mode
 *      as our only need with clients is tracking how to send them
 *      messages
 */
typedef struct _client_t{
	tptp_uint32  clientID;
}client_t;

/*
 * Process
 */
typedef struct _process_t{
	PID               pid;                  /* Real process ID of the process */
/* BEGIN:  235649 */
#if defined __linux__
	PID               pid2;
#endif
/* END: 235649 */
	BOOL			isActive;             /* Is the process alive? */
	ra_string_t		uuid;	                /* UUID of the process */
	unsigned short	active_agent_count;   /* Number of active agents */
	unsigned short	waiting_agent_count;  /* Number of waiting agents */
	ra_string_t		processName;          /* The application name of the process */
	agent_list_t	active_agents;        /* List of active, currently registered, agents */
	agent_list_t	waiting_clients;      /* List of agents which have clients waiting on them */
	struct _process_list_node *node;        /* Back pointer to it's list node */
	SOCKET			console; /* 9707 */
}process_t;


typedef struct _process_list_node {
	process_t *process;
	struct _process_list_node *next;
	struct _process_list_node *previous;
	struct _process_list *list;
}process_list_node_t;

typedef struct _process_list{
	unsigned short process_count;
    ra_critsec_t   lock;
	process_list_node_t *head;
	process_list_node_t *tail;
	void *stateData;
}process_list_t;

typedef struct {
	ra_string_t type;
	ra_string_t name;
	ra_string_t value;
}option_t;

typedef struct _option_list_node{
	option_t *option;
	struct _option_list_node *next;
	struct _option_list_node *previous;
}option_list_node_t;

typedef struct {
	unsigned int option_count;
	option_list_node_t *head;
	option_list_node_t *tail;
}option_list_t;

#ifdef __cplusplus
}
#endif


#endif

