/*******************************************************************************
 * Copyright (c) 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Igor Alelekov, Intel - Initial API and implementation
 *
 * $Id: tptpSSLProvider.h,v 1.2 2008/02/06 12:38:47 ialelekov Exp $
 *******************************************************************************/ 

#ifndef _TPTP_SSL_PROVIDER_H
#define _TPTP_SSL_PROVIDER_H

typedef struct {
  	tptp_object* cmo;
  	logEventEntry_ptr_t logEventEntry;
} log_service_t;

/*
 * Interface functions for SSL provider
 */
 
#ifdef __cplusplus
extern "C" {
#endif

int sslInit(log_service_t *logService, int port);

void* sslAccept();
int sslHandshake(void* handle);
int sslRead(void* handle, char* buffer, int length);
int sslWrite(void* handle, char* buffer, int length);
int sslClose(void* handle);
int sslReset();
char* sslGetProviderName();
char* sslGetValue(const char* name);
void sslSetValue(const char* name, const char* value);

#ifdef __cplusplus
}
#endif
 

#endif
