#!/bin/sh
#
# ACStart.sh - Starts the Agent Controller server process.
#

#
# If TPTP_AC_HOME is not set then set it to the parent directory of the directory containing this script
#
if [ -z "$TPTP_AC_HOME" ]; then
	TPTP_AC_HOME=`dirname "$0"`/..
	export TPTP_AC_HOME
fi
PATH="$TPTP_AC_HOME/bin":$PATH
export PATH

#
# Make sure TPTP_AC_HOME is valid
#
if [ -e "$TPTP_AC_HOME/bin/ACServer" ] ; then
	echo "Starting Agent Controller."
else
	echo "TPTP_AC_HOME not set properly. Could not locate bin/ACServer at that location."
	echo "TPTP_AC_HOME=" $TPTP_AC_HOME
	exit 67
fi

#
# Bug 301163, check for the serviceconfig.xml
# Parse the configuration file for the location of the jvm library
#
if [ -e "$TPTP_AC_HOME/config/serviceconfig.xml" ] ; then
    JVM_LIB=`grep '<Jvm' "$TPTP_AC_HOME/config/serviceconfig.xml" | sed 's/<Jvm location="\(.*\)"\/>/\1/'`
    export JVM_LIB

#
# Set the library path(s) based on the location of the jvm library (".." is the parent directory which
# also holds other dependent *.so)
#
	LIBPATH="$TPTP_AC_HOME/lib":`echo $JVM_LIB | sed 's/\(.*\)\/libjvm\.so/\1/'`:`echo $JVM_LIB | sed 's/\(.*\)\/libjvm\.so/\1/' | sed 's/\(.*\)\/.*/\1/'`:/usr/lib:$LIBPATH
	
	export PATH_32BITJVM=`echo $JVM_LIB | sed 's/\(.*\)\/libjvm\.so/\1/' | sed 's/\(.*\)\/.*/\1/'`/../lib/ppc
	export PATH_64BITJVM=`echo $JVM_LIB | sed 's/\(.*\)\/libjvm\.so/\1/' | sed 's/\(.*\)\/.*/\1/'`/../lib/ppc64
	export PATH_64BITJVM2=`echo $JVM_LIB | sed 's/\(.*\)\/libjvm\.so/\1/' | sed 's/\(.*\)\/.*/\1/'`/../../lib/ppc64
	export PATH_64BITJVM3=`echo $JVM_LIB | sed 's/\(.*\)\/libjvm\.so/\1/' | sed 's/\(.*\)\/.*/\1/'`/../../../lib/ppc64

	if [ -e "$PATH_32BITJVM" ] ; then
		export LIBPATH=$PATH_32BITJVM:$LIBPATH
	fi

	if [ -e "$PATH_64BITJVM" ] ; then
		export LIBPATH=$PATH_64BITJVM:$LIBPATH
	fi

	if [ -e "$PATH_64BITJVM2" ] ; then
		export LIBPATH=$PATH_64BITJVM2:$LIBPATH
	fi

	if [ -e "$PATH_64BITJVM3" ] ; then
		export LIBPATH=$PATH_64BITJVM3:$LIBPATH
	fi
	
else
	LIBPATH="$TPTP_AC_HOME/lib":/usr/lib:$LIBPATH
fi
export LIBPATH


#
# Bug 175696, 201989
# Make sure TEMP dir is set
#
if [[ -n $TEMP ]]; then
	if [[ -d $TEMP ]]; then
		echo
	else
		export TEMP=/tmp
	fi
else
	export TEMP=/tmp
fi

#
# Start the ACServer
#
RUNNING=`ps -ae | grep "ACServer" | wc -l`
if [ $RUNNING -ne 0 ];then
	ps -ae | grep "ACServer" | awk '{
  	print "The server is already running on pid " $1
	}'      
	exit 66
else
    ACServer "$@" &
fi

#
# Wait for the process to come up in the system process list
#
sleep 2

#
# Check if ACServer is running by querying the system process list
#
RUNNING=`ps -ae | grep "ACServer" | wc -l`
if [ $RUNNING -ne 0 ];then
    echo "ACServer started successfully."
    exit 0
else
    echo "ACServer failed to start."
    exit 1
fi

