#!/bin/sh
#
# ACStop.sh - Stops the Agent Controller server process if it is running.
#

# If TPTP_AC_HOME is not set then set it to the parent directory of the directory containing this script
#
if [ -z "$TPTP_AC_HOME" ]; then
	TPTP_AC_HOME=`dirname "$0"`/..
	export TPTP_AC_HOME
fi
PATH="$TPTP_AC_HOME/bin":$PATH
export PATH

# Bug 301163, check for the serviceconfig.xml
if [ -e "$TPTP_AC_HOME/config/serviceconfig.xml" ]; then
	JVM_LIB=`grep '<Jvm' "$TPTP_AC_HOME/config/serviceconfig.xml" | sed 's/<Jvm location="\(.*\)"\/>/\1/'`
	LIBPATH="$TPTP_AC_HOME/lib":`echo $JVM_LIB | sed 's/\(.*\)\/libjvm\.so/\1/'`:`echo $JVM_LIB | sed 's/\(.*\)\/libjvm\.so/\1/' | sed 's/\(.*\)\/.*/\1/'`:/usr/lib:$LIBPATH
	
	export PATH_32BITJVM=`echo $JVM_LIB | sed 's/\(.*\)\/libjvm\.so/\1/' | sed 's/\(.*\)\/.*/\1/'`/../lib/ppc
	export PATH_64BITJVM=`echo $JVM_LIB | sed 's/\(.*\)\/libjvm\.so/\1/' | sed 's/\(.*\)\/.*/\1/'`/../lib/ppc64
	export PATH_64BITJVM2=`echo $JVM_LIB | sed 's/\(.*\)\/libjvm\.so/\1/' | sed 's/\(.*\)\/.*/\1/'`/../../lib/ppc64
	export PATH_64BITJVM3=`echo $JVM_LIB | sed 's/\(.*\)\/libjvm\.so/\1/' | sed 's/\(.*\)\/.*/\1/'`/../../../lib/ppc64	

	if [ -e "$PATH_32BITJVM" ] ; then
		export LIBPATH=$PATH_32BITJVM:$LIBPATH
	fi

	if [ -e "$PATH_64BITJVM" ] ; then
		export LIBPATH=$PATH_64BITJVM:$LIBPATH
	fi
	
	if [ -e "$PATH_64BITJVM2" ] ; then
		export LIBPATH=$PATH_64BITJVM2:$LIBPATH
	fi

	if [ -e "$PATH_64BITJVM3" ] ; then
		export LIBPATH=$PATH_64BITJVM3:$LIBPATH
	fi	
	
else
	LIBPATH="$TPTP_AC_HOME/lib":/usr/lib:$LIBPATH
fi

# Set LD_LIBRARY_PATH because we are going to run another occurrence of the server
# that will tell the existing one to shutdown.
#LD_LIBRARY_PATH=$TPTP_AC_HOME/lib:$LD_LIBRARY_PATH
export LIBPATH

#
# Bug 175696, 201989
# Make sure TEMP dir is set
#
if [[ -n $TEMP ]]; then
	if [[ -d $TEMP ]]; then
		echo
	else
		export TEMP=/tmp
	fi
else
	export TEMP=/tmp
fi

RUNNING=`ps -ae | grep "ACServer" | wc -l`
if [ $RUNNING -ne 0 ];then
	ACServer -shutdown "$@"
	sleep 2
	RUNNING=`ps -ae | grep "ACServer" | wc -l`
	if [ $RUNNING -ne 0 ];then
		echo "ACServer failed to shutdown."
		exit 1
	else
    	echo "ACServer stopped."
    	exit 0
    fi
else
    echo "ACServer is not currently running."
    exit 0
fi
